/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.collision;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.impl.collision.CollisionResultc;
import org.valkyrienskies.core.impl.collision.NotCollidingException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0001.B\u001f\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b,\u0010-J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R\"\u0010\u000b\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u001a\u001a\u0004\b\u001b\u0010\u0004\"\u0004\b\u001c\u0010\u001dR\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001e\u001a\u0004\b\u001f\u0010\u0007R\"\u0010\r\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010 \u001a\u0004\b!\u0010\n\"\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0004R\u0014\u0010)\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010+\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\n\u00a8\u0006/"}, d2={"Lorg/valkyrienskies/core/impl/collision/CollisionResult;", "Lorg/valkyrienskies/core/impl/collision/CollisionResultc;", "", "component1", "()Z", "Lorg/joml/Vector3d;", "component2", "()Lorg/joml/Vector3d;", "", "component3", "()D", "_colliding", "_collisionAxis", "_penetrationOffset", "copy", "(ZLorg/joml/Vector3d;D)Lorg/valkyrienskies/core/impl/collision/CollisionResult;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Z", "get_colliding", "set_colliding", "(Z)V", "Lorg/joml/Vector3d;", "get_collisionAxis", "D", "get_penetrationOffset", "set_penetrationOffset", "(D)V", "getColliding", "colliding", "Lorg/joml/Vector3dc;", "getCollisionAxis", "()Lorg/joml/Vector3dc;", "collisionAxis", "getPenetrationOffset", "penetrationOffset", "<init>", "(ZLorg/joml/Vector3d;D)V", "Companion", "impl"})
public final class CollisionResult
implements CollisionResultc {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean _colliding;
    @NotNull
    private final Vector3d _collisionAxis;
    private double _penetrationOffset;

    public CollisionResult(boolean _colliding, @NotNull Vector3d _collisionAxis, double _penetrationOffset) {
        Intrinsics.checkNotNullParameter((Object)_collisionAxis, (String)"_collisionAxis");
        this._colliding = _colliding;
        this._collisionAxis = _collisionAxis;
        this._penetrationOffset = _penetrationOffset;
    }

    public final boolean get_colliding() {
        return this._colliding;
    }

    public final void set_colliding(boolean bl) {
        this._colliding = bl;
    }

    @NotNull
    public final Vector3d get_collisionAxis() {
        return this._collisionAxis;
    }

    public final double get_penetrationOffset() {
        return this._penetrationOffset;
    }

    public final void set_penetrationOffset(double d) {
        this._penetrationOffset = d;
    }

    @Override
    public boolean getColliding() {
        return this._colliding;
    }

    @Override
    @NotNull
    public Vector3dc getCollisionAxis() {
        if (!this.getColliding()) {
            throw new NotCollidingException("Cannot access collisionAxis because we are not colliding.");
        }
        return (Vector3dc)this._collisionAxis;
    }

    @Override
    public double getPenetrationOffset() {
        if (!this.getColliding()) {
            throw new NotCollidingException("Cannot access collisionRange because we are not colliding.");
        }
        return this._penetrationOffset;
    }

    public final boolean component1() {
        return this._colliding;
    }

    @NotNull
    public final Vector3d component2() {
        return this._collisionAxis;
    }

    public final double component3() {
        return this._penetrationOffset;
    }

    @NotNull
    public final CollisionResult copy(boolean _colliding, @NotNull Vector3d _collisionAxis, double _penetrationOffset) {
        Intrinsics.checkNotNullParameter((Object)_collisionAxis, (String)"_collisionAxis");
        return new CollisionResult(_colliding, _collisionAxis, _penetrationOffset);
    }

    public static /* synthetic */ CollisionResult copy$default(CollisionResult collisionResult, boolean bl, Vector3d vector3d, double d, int n, Object object) {
        if ((n & 1) != 0) {
            bl = collisionResult._colliding;
        }
        if ((n & 2) != 0) {
            vector3d = collisionResult._collisionAxis;
        }
        if ((n & 4) != 0) {
            d = collisionResult._penetrationOffset;
        }
        return collisionResult.copy(bl, vector3d, d);
    }

    @NotNull
    public String toString() {
        return "CollisionResult(_colliding=" + this._colliding + ", _collisionAxis=" + this._collisionAxis + ", _penetrationOffset=" + this._penetrationOffset + ')';
    }

    public int hashCode() {
        int n = this._colliding ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + this._collisionAxis.hashCode();
        result = result * 31 + Double.hashCode(this._penetrationOffset);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CollisionResult)) {
            return false;
        }
        CollisionResult collisionResult = (CollisionResult)other;
        if (this._colliding != collisionResult._colliding) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this._collisionAxis, (Object)collisionResult._collisionAxis)) {
            return false;
        }
        return Double.compare(this._penetrationOffset, collisionResult._penetrationOffset) == 0;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/core/impl/collision/CollisionResult$Companion;", "", "Lorg/valkyrienskies/core/impl/collision/CollisionResult;", "create", "()Lorg/valkyrienskies/core/impl/collision/CollisionResult;", "<init>", "()V", "impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CollisionResult create() {
            return new CollisionResult(false, new Vector3d(), 0.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

