/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.collision;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bR\u0014\u0010\u0005\u001a\u00020\u00028&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00028&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/valkyrienskies/core/impl/collision/CollisionRangec;", "", "", "getMax", "()D", "max", "getMin", "min", "Companion", "impl"})
public interface CollisionRangec {
    @NotNull
    public static final Companion Companion = org.valkyrienskies.core.impl.collision.CollisionRangec$Companion.$$INSTANCE;

    public double getMin();

    public double getMax();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\t\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/valkyrienskies/core/impl/collision/CollisionRangec$Companion;", "", "Lorg/valkyrienskies/core/impl/collision/CollisionRangec;", "collisionRange1", "collisionRange2", "", "computeCollisionResponse", "(Lorg/valkyrienskies/core/impl/collision/CollisionRangec;Lorg/valkyrienskies/core/impl/collision/CollisionRangec;)D", "collisionRange1Velocity", "computeCollisionResponseGivenVelocity", "(Lorg/valkyrienskies/core/impl/collision/CollisionRangec;Lorg/valkyrienskies/core/impl/collision/CollisionRangec;D)D", "computeCollisionTime", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        public final double computeCollisionResponse(@NotNull CollisionRangec collisionRange1, @NotNull CollisionRangec collisionRange2) {
            Intrinsics.checkNotNullParameter((Object)collisionRange1, (String)"collisionRange1");
            Intrinsics.checkNotNullParameter((Object)collisionRange2, (String)"collisionRange2");
            double pushLeft = -collisionRange1.getMax() + collisionRange2.getMin();
            double pushRight = -collisionRange1.getMin() + collisionRange2.getMax();
            return pushRight <= 0.0 || pushLeft >= 0.0 ? 0.0 : (Math.abs(pushRight) < Math.abs(pushLeft) ? pushRight : pushLeft);
        }

        public final double computeCollisionResponseGivenVelocity(@NotNull CollisionRangec collisionRange1, @NotNull CollisionRangec collisionRange2, double collisionRange1Velocity) {
            Intrinsics.checkNotNullParameter((Object)collisionRange1, (String)"collisionRange1");
            Intrinsics.checkNotNullParameter((Object)collisionRange2, (String)"collisionRange2");
            double pushLeftOriginal = -collisionRange1.getMax() + collisionRange2.getMin();
            double pushRightOriginal = -collisionRange1.getMin() + collisionRange2.getMax();
            if (Math.abs(pushRightOriginal) < Math.abs(pushLeftOriginal)) {
                double collisionResponse = pushRightOriginal - collisionRange1Velocity;
                return collisionResponse > 0.0 ? collisionResponse : 0.0;
            }
            double collisionResponse = pushLeftOriginal - collisionRange1Velocity;
            return collisionResponse < 0.0 ? collisionResponse : 0.0;
        }

        public final double computeCollisionTime(@NotNull CollisionRangec collisionRange1, @NotNull CollisionRangec collisionRange2, double collisionRange1Velocity) {
            double d;
            Intrinsics.checkNotNullParameter((Object)collisionRange1, (String)"collisionRange1");
            Intrinsics.checkNotNullParameter((Object)collisionRange2, (String)"collisionRange2");
            double pushLeft = -collisionRange1.getMax() + collisionRange2.getMin();
            double pushRight = -collisionRange1.getMin() + collisionRange2.getMax();
            if (pushRight <= 0.0 || pushLeft >= 0.0) {
                if (Math.abs(collisionRange1Velocity) < 1.0E-8) {
                    return Double.POSITIVE_INFINITY;
                }
                d = collisionRange1Velocity > 0.0 ? (pushLeft >= 0.0 ? Math.abs(pushLeft / collisionRange1Velocity) : Double.POSITIVE_INFINITY) : (pushRight <= 0.0 ? Math.abs(pushRight / collisionRange1Velocity) : Double.POSITIVE_INFINITY);
            } else {
                d = 0.0;
            }
            return d;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

