/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.api;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.impl.api.ServerShipProvider;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J&\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0004\u001a\u00020\u00032\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ.\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\t\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/valkyrienskies/core/impl/api/ShipValueDelegate;", "T", "", "Lorg/valkyrienskies/core/impl/api/ServerShipProvider;", "thisRef", "Lkotlin/reflect/KProperty;", "property", "getValue", "(Lorg/valkyrienskies/core/impl/api/ServerShipProvider;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "value", "", "setValue", "(Lorg/valkyrienskies/core/impl/api/ServerShipProvider;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "Ljava/lang/Class;", "clazz", "Ljava/lang/Class;", "", "persistent", "Z", "<init>", "(Ljava/lang/Class;Z)V", "impl"})
public class ShipValueDelegate<T> {
    @NotNull
    private final Class<T> clazz;
    private final boolean persistent;

    public ShipValueDelegate(@NotNull Class<T> clazz, boolean persistent) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.clazz = clazz;
        this.persistent = persistent;
    }

    @Nullable
    public T getValue(@NotNull ServerShipProvider thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        ServerShip serverShip = thisRef.getShip();
        return (T)(serverShip != null ? serverShip.getAttachment(this.clazz) : null);
    }

    public void setValue(@NotNull ServerShipProvider thisRef, @NotNull KProperty<?> property, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (this.persistent) {
            ServerShip serverShip = thisRef.getShip();
            Intrinsics.checkNotNull((Object)serverShip);
            serverShip.saveAttachment(this.clazz, value);
        } else {
            boolean bl = thisRef.getShip() instanceof LoadedServerShip;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ServerShip serverShip = thisRef.getShip();
            Intrinsics.checkNotNull((Object)serverShip);
            ((LoadedServerShip)serverShip).setAttachment(this.clazz, value);
        }
    }
}

