/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.network;

import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketRequestItem {
    private final ResourceKey<Level> dimensionId;
    private final BlockPos pos;
    private final BlockPos inventoryPos;
    private final ItemStack item;
    private final int amount;
    private final boolean craftable;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimensionId.m_135782_());
        buf.m_130064_(this.pos);
        buf.m_130064_(this.inventoryPos);
        buf.writeInt(this.amount);
        NetworkTools.writeItemStack((FriendlyByteBuf)buf, (ItemStack)this.item);
        buf.writeBoolean(this.craftable);
    }

    public PacketRequestItem(FriendlyByteBuf buf) {
        this.dimensionId = LevelTools.getId((ResourceLocation)buf.m_130281_());
        this.pos = buf.m_130135_();
        this.inventoryPos = buf.m_130135_();
        this.amount = buf.readInt();
        this.item = NetworkTools.readItemStack((FriendlyByteBuf)buf);
        this.craftable = buf.readBoolean();
    }

    public PacketRequestItem(ResourceKey<Level> dimensionId, BlockPos pos, BlockPos inventoryPos, ItemStack item, int amount, boolean craftable) {
        this.dimensionId = dimensionId;
        this.pos = pos;
        this.inventoryPos = inventoryPos;
        this.item = item;
        this.amount = amount;
        this.craftable = craftable;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerLevel world = LevelTools.getLevel((Level)ctx.getSender().m_9236_(), this.dimensionId);
            if (world == null) {
                return;
            }
            if (!LevelTools.isLoaded((Level)world, (BlockPos)this.pos)) {
                return;
            }
            BlockEntity te = world.m_7702_(this.pos);
            if (te instanceof StorageScannerTileEntity) {
                StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
                if (this.craftable) {
                    scanner.requestCraft(this.inventoryPos, this.item, this.amount, (Player)ctx.getSender());
                } else {
                    scanner.requestStack(this.inventoryPos, this.item, this.amount, (Player)ctx.getSender());
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

