/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.setup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gems.item.GemsFoodItem;
import net.silentchaos512.gems.item.PetSummonerItem;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.item.container.FlowerBasketItem;
import net.silentchaos512.gems.item.container.GemBagItem;
import net.silentchaos512.gems.setup.Registration;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.registry.ItemRegistryObject;

public final class GemsItems {
    private static final Collection<ItemRegistryObject<? extends Item>> SIMPLE_MODEL_ITEMS = new ArrayList<ItemRegistryObject<? extends Item>>();
    public static final ItemRegistryObject<Item> RAW_SILVER;
    public static final ItemRegistryObject<Item> SILVER_INGOT;
    public static final ItemRegistryObject<Item> SILVER_NUGGET;
    public static final ItemRegistryObject<Item> LOLINOMICON;
    public static final ItemRegistryObject<SoulGemItem> SOUL_GEM;
    public static final ItemRegistryObject<GemBagItem> GEM_BAG;
    public static final ItemRegistryObject<FlowerBasketItem> FLOWER_BASKET;
    public static final ItemRegistryObject<PetSummonerItem> SUMMON_KITTY;
    public static final ItemRegistryObject<PetSummonerItem> SUMMON_PUPPY;
    public static final ItemRegistryObject<Item> POTATO_ON_A_STICK;
    public static final ItemRegistryObject<Item> SUGAR_COOKIE;
    public static final ItemRegistryObject<Item> UNCOOKED_MEATY_STEW;
    public static final ItemRegistryObject<Item> MEATY_STEW;
    public static final ItemRegistryObject<Item> UNCOOKED_FISHY_STEW;
    public static final ItemRegistryObject<Item> FISHY_STEW;
    public static final ItemRegistryObject<Item> IRON_POTATO;

    private GemsItems() {
    }

    static void register() {
    }

    public static Collection<ItemRegistryObject<? extends Item>> getSimpleModelItems() {
        return Collections.unmodifiableCollection(SIMPLE_MODEL_ITEMS);
    }

    private static <T extends Item> ItemRegistryObject<T> register(String name, Supplier<T> item) {
        return new ItemRegistryObject(Registration.ITEMS.register(name, item));
    }

    private static <T extends Item> ItemRegistryObject<T> registerSimpleModel(String name, Supplier<T> item) {
        ItemRegistryObject<T> ret = GemsItems.register(name, item);
        SIMPLE_MODEL_ITEMS.add(ret);
        return ret;
    }

    private static ItemRegistryObject<Item> registerCraftingItem(String name) {
        return GemsItems.registerSimpleModel(name, () -> new Item(GemsItems.baseProps()));
    }

    private static ItemRegistryObject<Item> registerFood(String name, @Nullable ItemLike returnItem, FoodProperties.Builder foodBuilder) {
        ItemRegistryObject<Item> ret = GemsItems.register(name, () -> new GemsFoodItem(foodBuilder, returnItem, GemsItems.baseProps()));
        SIMPLE_MODEL_ITEMS.add(ret);
        return ret;
    }

    private static Item.Properties baseProps() {
        return new Item.Properties();
    }

    private static Item.Properties unstackableProps() {
        return GemsItems.baseProps().m_41487_(1);
    }

    static {
        Gems.registerItems();
        RAW_SILVER = GemsItems.registerCraftingItem("raw_silver");
        SILVER_INGOT = GemsItems.registerCraftingItem("silver_ingot");
        SILVER_NUGGET = GemsItems.registerCraftingItem("silver_nugget");
        LOLINOMICON = GemsItems.registerCraftingItem("lolinomicon");
        SOUL_GEM = GemsItems.register("soul_gem", () -> new SoulGemItem(GemsItems.unstackableProps()));
        GEM_BAG = GemsItems.register("gem_bag", () -> new GemBagItem(GemsItems.unstackableProps()));
        FLOWER_BASKET = GemsItems.register("flower_basket", () -> new FlowerBasketItem(GemsItems.unstackableProps()));
        SUMMON_KITTY = GemsItems.registerSimpleModel("summon_kitty", () -> new PetSummonerItem(PetSummonerItem::getCat, GemsItems.baseProps()));
        SUMMON_PUPPY = GemsItems.registerSimpleModel("summon_puppy", () -> new PetSummonerItem(PetSummonerItem::getDog, GemsItems.baseProps()));
        POTATO_ON_A_STICK = GemsItems.registerFood("potato_on_a_stick", (ItemLike)Items.f_42398_, new FoodProperties.Builder().m_38760_(6).m_38758_(0.7f));
        SUGAR_COOKIE = GemsItems.registerFood("sugar_cookie", null, new FoodProperties.Builder().m_38760_(2).m_38758_(0.4f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19596_, 600), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19598_, 400), 1.0f));
        UNCOOKED_MEATY_STEW = GemsItems.registerFood("uncooked_meaty_stew", (ItemLike)Items.f_42399_, new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f));
        MEATY_STEW = GemsItems.registerFood("meaty_stew", (ItemLike)Items.f_42399_, new FoodProperties.Builder().m_38760_(12).m_38758_(1.6f));
        UNCOOKED_FISHY_STEW = GemsItems.registerFood("uncooked_fishy_stew", (ItemLike)Items.f_42399_, new FoodProperties.Builder().m_38760_(4).m_38758_(0.5f));
        FISHY_STEW = GemsItems.registerFood("fishy_stew", (ItemLike)Items.f_42399_, new FoodProperties.Builder().m_38760_(10).m_38758_(1.2f));
        IRON_POTATO = GemsItems.registerFood("iron_potato", null, new FoodProperties.Builder().m_38760_(9).m_38758_(0.9f).m_38765_().effect(() -> new MobEffectInstance(MobEffects.f_19617_, 12000, 4), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19606_, 6000, 0), 1.0f).effect(() -> new MobEffectInstance(MobEffects.f_19600_, 6000, 1), 1.0f));
    }
}

