/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.setup.Registration;
import net.silentchaos512.gems.util.Gems;

public class GemsLootTableProvider
extends LootTableProvider {
    public GemsLootTableProvider(DataGenerator gen) {
        super(gen.getPackOutput(), Collections.emptySet(), VanillaLootTableProvider.m_247452_((PackOutput)gen.getPackOutput()).getTables());
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(BlockLootTables::new, LootContextParamSets.f_81421_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
        map.forEach((name, loo) -> loo.m_79136_(validationContext.m_79355_(loo.m_79122_()).m_278632_("{" + name + "}", new LootDataId(LootDataType.f_278413_, name))));
    }

    private static final class BlockLootTables
    extends BlockLootSubProvider {
        protected BlockLootTables() {
            super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            for (Gems gem : Gems.values()) {
                this.registerFortuneDrops((Block)gem.getOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getDeepslateOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getNetherOre(), gem.getItem());
                this.registerFortuneDrops((Block)gem.getEndOre(), gem.getItem());
                this.m_245724_(gem.getBlock());
                this.m_245724_(gem.getBricks());
                this.m_245724_(gem.getTiles());
                this.m_245724_(gem.getSmallBricks());
                this.m_245724_(gem.getPolishedStone());
                this.m_245724_(gem.getSmoothStone());
                this.m_245724_(gem.getChiseledStone());
                this.m_245724_((Block)gem.getGlass());
                for (GemLampBlock.State state : GemLampBlock.State.values()) {
                    this.m_246125_(gem.getLamp(state), (ItemLike)gem.getLamp(state.withPower(false)));
                }
                this.m_245724_((Block)gem.getGlowrose());
                this.m_246535_((Block)gem.getPottedGlowrose());
            }
            this.registerFortuneDrops((Block)GemsBlocks.SILVER_ORE.get(), (Item)GemsItems.RAW_SILVER.get());
            this.registerFortuneDrops((Block)GemsBlocks.DEEPSLATE_SILVER_ORE.get(), (Item)GemsItems.RAW_SILVER.get());
            this.m_245724_((Block)GemsBlocks.SILVER_BLOCK.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        private void registerFortuneDrops(Block block, Item item) {
            this.m_247577_(block, this.m_246109_(block, item));
        }
    }
}

