/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.chunk;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerChunkData {
    private ChunkPos lastChunk = ChunkPos.f_186419_;
    private ResourceKey<Level> lastLevel = null;
    private BlockPos[] predictionLastChunkpositions = new BlockPos[6];
    private int predictionIndex = 0;
    private ChunkPos predictionOldestPositionsAvg = ChunkPos.f_186419_;
    private ChunkPos predictionNewestPositionsAvg = ChunkPos.f_186419_;
    private ChunkPos lastChunkTicket = ChunkPos.f_186419_;
    private int lastChunkTicketLevel = 0;
    private BlockPos[] lazyLoadingLastChunkPositions = new BlockPos[6];
    private int lazyLoadingIndex = 0;
    private ChunkPos lazyLoadingAvgChunkpos = null;
    private ChunkPos lazyLoadingLastTicketPos = null;

    public void onChunkChanged(ServerPlayer player) {
        if (!player.m_9236_().m_46472_().equals(this.lastLevel)) {
            this.lastLevel = player.m_9236_().m_46472_();
            this.predictionLastChunkpositions = new BlockPos[6];
            this.predictionIndex = 0;
            this.predictionOldestPositionsAvg = ChunkPos.f_186419_;
            this.predictionNewestPositionsAvg = ChunkPos.f_186419_;
            this.lastChunkTicket = ChunkPos.f_186419_;
            this.lastChunkTicketLevel = 0;
            this.lazyLoadingLastChunkPositions = new BlockPos[6];
            this.lastChunk = null;
        }
        if (player.m_146902_().equals((Object)this.lastChunk)) {
            return;
        }
        if (this.lastChunk != null && player.m_146902_().m_45594_(this.lastChunk) > 2) {
            this.predictionLastChunkpositions = new BlockPos[6];
            this.predictionIndex = 0;
            this.predictionOldestPositionsAvg = ChunkPos.f_186419_;
            this.predictionNewestPositionsAvg = ChunkPos.f_186419_;
            this.lazyLoadingLastChunkPositions = new BlockPos[6];
        }
        this.lastChunk = player.m_146902_();
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableLazyChunkloading) {
            this.updateSlowAvgChunkPos(player);
        }
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enablePrediction) {
            this.checkPrediction(player);
        }
    }

    private void updateSlowAvgChunkPos(ServerPlayer player) {
        int cacheSize = Math.max(1, (int)((double)((ServerChunkCache)player.m_9236_().m_7726_()).f_8325_.f_140126_ / ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).lazyloadingspeed));
        if (this.lazyLoadingLastChunkPositions.length != cacheSize) {
            BlockPos[] newArray = new BlockPos[cacheSize];
            for (int i = 0; i < Math.min(cacheSize, this.lazyLoadingLastChunkPositions.length); ++i) {
                newArray[i] = this.lazyLoadingLastChunkPositions[i];
            }
            this.lazyLoadingLastChunkPositions = newArray;
            this.lazyLoadingIndex %= cacheSize;
        }
        this.lazyLoadingIndex = (this.lazyLoadingIndex + 1) % this.lazyLoadingLastChunkPositions.length;
        this.lazyLoadingLastChunkPositions[this.lazyLoadingIndex] = new BlockPos(player.m_146903_(), 0, player.m_146907_());
        int amount = 0;
        BlockPos posAvg = BlockPos.f_121853_;
        for (int i = 0; i < cacheSize; ++i) {
            BlockPos pos = this.lazyLoadingLastChunkPositions[i];
            if (pos == null) continue;
            posAvg = posAvg.m_121955_((Vec3i)pos);
            ++amount;
        }
        posAvg = new BlockPos(posAvg.m_123341_() / amount, 0, posAvg.m_123343_() / amount);
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging && !new ChunkPos(posAvg).equals((Object)this.lazyLoadingAvgChunkpos)) {
            BetterChunkLoading.LOGGER.info("Set lazy player chunkloading chunk position to: " + new ChunkPos(posAvg) + ", player chunk pos:" + player.m_146902_());
        }
        this.lazyLoadingAvgChunkpos = new ChunkPos(posAvg);
    }

    public ChunkPos getSlowAvgPos() {
        return this.lazyLoadingAvgChunkpos;
    }

    public ChunkPos getLazyLoadingLastTicketPos() {
        return this.lazyLoadingLastTicketPos;
    }

    public void setLazyLoadingLastTicketPos(ChunkPos lastChunk) {
        if (lastChunk != null && this.lazyLoadingLastTicketPos != null) {
            BetterChunkLoading.LOGGER.error("Did not unload previous position!", (Throwable)new Exception());
        }
        this.lazyLoadingLastTicketPos = lastChunk;
    }

    private void checkPrediction(ServerPlayer player) {
        this.predictionLastChunkpositions[this.predictionIndex] = new BlockPos(player.m_146903_(), 0, player.m_146907_());
        this.predictionIndex = (this.predictionIndex + 1) % 6;
        BlockPos avgOldest = BlockPos.f_121853_;
        for (int i = 0; i < 3; ++i) {
            if (this.predictionLastChunkpositions[(this.predictionIndex + i) % 6] == null) {
                return;
            }
            avgOldest = avgOldest.m_121955_((Vec3i)this.predictionLastChunkpositions[(this.predictionIndex + i) % 6]);
        }
        avgOldest = new BlockPos(avgOldest.m_123341_() / 3, 0, avgOldest.m_123343_() / 3);
        BlockPos avgNewest = BlockPos.f_121853_;
        for (int i = 3; i < 6; ++i) {
            if (this.predictionLastChunkpositions[(this.predictionIndex + i) % 6] == null) {
                return;
            }
            avgNewest = avgNewest.m_121955_((Vec3i)this.predictionLastChunkpositions[(this.predictionIndex + i) % 6]);
        }
        avgNewest = new BlockPos(avgNewest.m_123341_() / 3, 0, avgNewest.m_123343_() / 3);
        ChunkPos newOldest = new ChunkPos(avgOldest);
        ChunkPos newNewest = new ChunkPos(avgNewest);
        if (!newNewest.equals((Object)this.predictionNewestPositionsAvg) || !newOldest.equals((Object)this.predictionOldestPositionsAvg)) {
            this.predictionNewestPositionsAvg = newNewest;
            this.predictionOldestPositionsAvg = newOldest;
            Vec3 direction = Vec3.m_82539_((Vec3i)avgOldest).m_82546_(Vec3.m_82539_((Vec3i)avgNewest)).m_82548_();
            Vec3 currentpos = Vec3.m_82539_((Vec3i)avgNewest);
            currentpos = currentpos.m_82549_(direction.m_82490_((double)(((ServerChunkCache)player.m_9236_().m_7726_()).f_8325_.m_143145_().f_183902_ + ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictiondidstanceoffset) / 3.0));
            ChunkPos currentChunk = new ChunkPos((int)currentpos.f_82479_ >> 4, (int)currentpos.f_82481_ >> 4);
            if (this.lastChunkTicket.equals((Object)currentChunk)) {
                return;
            }
            if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
                BetterChunkLoading.LOGGER.info("Set predictive loading position with area:" + ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea + " to chunk: " + currentChunk + " player chunk:" + player.m_146902_());
            }
            ((ServerChunkCache)player.m_9236_().m_7726_()).m_8387_(BetterChunkLoading.TICKET_1min, currentChunk, ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea, (Object)currentChunk);
            if (!this.lastChunkTicket.equals((Object)ChunkPos.f_186419_)) {
                ((ServerChunkCache)player.m_9236_().m_7726_()).m_8438_(BetterChunkLoading.TICKET_1min, this.lastChunkTicket, this.lastChunkTicketLevel, (Object)this.lastChunkTicket);
            }
            this.lastChunkTicket = currentChunk;
            this.lastChunkTicketLevel = ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea;
        }
    }
}

