/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.tileentities;

import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.WarehouseModule;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWareHouse
extends AbstractTileEntityWareHouse {
    private long lastNotification = 0L;

    public TileEntityWareHouse(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityWareHouse>)((BlockEntityType)MinecoloniesTileEntities.WAREHOUSE.get()), pos, state);
        this.inWarehouse = true;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate, int count) {
        List<Tuple<ItemStack, BlockPos>> targetStacks = this.getMatchingItemStacksInWarehouse(itemStackSelectionPredicate);
        return targetStacks.stream().mapToInt(tuple -> ItemStackUtils.getSize((ItemStack)tuple.getA())).sum() >= count;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT) {
        return this.hasMatchingItemStackInWarehouse(itemStack, count, ignoreNBT, 0);
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT, boolean ignoreDamage, int leftOver) {
        int totalCountFound = 0 - leftOver;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, pos) || !((entity = this.m_58904_().m_7702_(pos)) instanceof TileEntityRack) || ((AbstractTileEntityRack)entity).isEmpty() || (totalCountFound += ((AbstractTileEntityRack)entity).getCount(itemStack, ignoreDamage, ignoreNBT)) < count) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMatchingItemStackInWarehouse(@NotNull ItemStack itemStack, int count, boolean ignoreNBT, int leftOver) {
        return this.hasMatchingItemStackInWarehouse(itemStack, count, ignoreNBT, true, leftOver);
    }

    @Override
    @NotNull
    public List<Tuple<ItemStack, BlockPos>> getMatchingItemStacksInWarehouse(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        ArrayList<Tuple<ItemStack, BlockPos>> found = new ArrayList<Tuple<ItemStack, BlockPos>>();
        if (this.getBuilding() != null) {
            for (BlockPos pos : this.getBuilding().getContainers()) {
                BlockEntity entity = this.m_58904_().m_7702_(pos);
                if (entity instanceof TileEntityRack && !((AbstractTileEntityRack)entity).isEmpty() && ((AbstractTileEntityRack)entity).getItemCount(itemStackSelectionPredicate) > 0) {
                    TileEntityRack rack = (TileEntityRack)entity;
                    for (ItemStack stack : InventoryUtils.filterItemHandler((IItemHandler)rack.getInventory(), itemStackSelectionPredicate)) {
                        found.add(new Tuple<ItemStack, BlockPos>(stack, pos));
                    }
                }
                if (!(entity instanceof ChestBlockEntity) || !InventoryUtils.hasItemInItemHandler((IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseGet(null), itemStackSelectionPredicate)) continue;
                for (ItemStack stack : InventoryUtils.filterItemHandler((IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseGet(null), itemStackSelectionPredicate)) {
                    found.add(new Tuple<ItemStack, BlockPos>(stack, pos));
                }
            }
        }
        return found;
    }

    @Override
    public void dumpInventoryIntoWareHouse(@NotNull InventoryCitizen inventoryCitizen) {
        for (int i = 0; i < inventoryCitizen.getSlots(); ++i) {
            ItemStack stack = inventoryCitizen.getStackInSlot(i);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            @Nullable BlockEntity chest = this.getRackForStack(stack);
            if (chest == null) {
                if (this.f_58857_.m_46467_() - this.lastNotification > 6000L) {
                    this.lastNotification = this.f_58857_.m_46467_();
                    if (this.getBuilding().getBuildingLevel() == this.getBuilding().getMaxBuildingLevel()) {
                        if (((WarehouseModule)this.getBuilding().getFirstModuleOccurance(WarehouseModule.class)).getStorageUpgrade() < 3) {
                            MessageUtils.format("com.minecolonies.coremod.warehouse.full.level5", new Object[0]).sendTo(this.getColony()).forAllPlayers();
                        } else {
                            MessageUtils.format("com.minecolonies.coremod.warehouse.full.max", new Object[0]).sendTo(this.getColony()).forAllPlayers();
                        }
                    } else {
                        MessageUtils.format("com.minecolonies.coremod.warehouse.full", new Object[0]).sendTo(this.getColony()).forAllPlayers();
                    }
                }
                return;
            }
            int index = i;
            chest.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((IItemHandler)inventoryCitizen, index, handler));
        }
    }

    public BlockEntity getRackForStack(ItemStack stack) {
        BlockEntity rack = this.getPositionOfChestWithItemStack(stack);
        if (rack == null && (rack = this.getPositionOfChestWithSimilarItemStack(stack)) == null) {
            rack = this.searchMostEmptyRack();
        }
        return rack;
    }

    @Nullable
    private BlockEntity getPositionOfChestWithItemStack(@NotNull ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, pos) || !((entity = this.m_58904_().m_7702_(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasItemStack(stack, 1, true)) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    private BlockEntity getPositionOfChestWithSimilarItemStack(ItemStack stack) {
        for (BlockPos pos : this.getBuilding().getContainers()) {
            BlockEntity entity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, pos) || !((entity = this.m_58904_().m_7702_(pos)) instanceof AbstractTileEntityRack) || ((AbstractTileEntityRack)entity).getFreeSlots() <= 0 || !((AbstractTileEntityRack)entity).hasSimilarStack(stack)) continue;
            return entity;
        }
        return null;
    }

    @Nullable
    private BlockEntity searchMostEmptyRack() {
        int freeSlots = 0;
        BlockEntity emptiestChest = null;
        for (BlockPos pos : this.getBuilding().getContainers()) {
            BlockEntity entity = this.m_58904_().m_7702_(pos);
            if (!(entity instanceof TileEntityRack)) continue;
            if (((AbstractTileEntityRack)entity).isEmpty()) {
                return entity;
            }
            int tempFreeSlots = ((AbstractTileEntityRack)entity).getFreeSlots();
            if (tempFreeSlots <= freeSlots) continue;
            freeSlots = tempFreeSlots;
            emptiestChest = entity;
        }
        return emptiestChest;
    }
}

