/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.rewards;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.api.util.Log;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.Holder;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemRewardTemplate
implements IQuestRewardTemplate {
    private final ItemStack item;

    public ItemRewardTemplate(ItemStack item) {
        this.item = item;
    }

    public static IQuestRewardTemplate createReward(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int quantity = details.get("qty").getAsInt();
        ItemStack item = new ItemStack((ItemLike)((Holder)ForgeRegistries.ITEMS.getHolder(new ResourceLocation(details.get("item").getAsString())).get()).get());
        if (details.has("nbt")) {
            try {
                item.m_41751_(TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)details, (String)"nbt")));
            }
            catch (CommandSyntaxException e) {
                Log.getLogger().error("Unable to load itemstack nbt from json!");
                throw new RuntimeException(e);
            }
        }
        item.m_41764_(quantity);
        return new ItemRewardTemplate(item);
    }

    @Override
    public void applyReward(IColony colony, Player player, IQuestInstance colonyQuest) {
        player.m_150109_().m_36054_(this.item);
    }
}

