/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestGiver;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestParticipant;
import com.minecolonies.api.quests.IQuestTemplate;
import com.minecolonies.api.quests.ITriggerReturnData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class QuestInstance
implements IQuestInstance {
    private final IColony colony;
    private ResourceLocation questTemplateID;
    private int questGiver = Integer.MIN_VALUE;
    private final List<Integer> questParticipants = new ArrayList<Integer>();
    private int assignmentStart;
    private int objectiveProgress = 0;
    private IObjectiveInstance currentObjectiveInstance = null;
    private UUID assignedPlayer = null;

    protected QuestInstance(ResourceLocation questTemplateID, IColony colony, List<ITriggerReturnData<?>> triggerReturnData) {
        this.colony = colony;
        this.questTemplateID = questTemplateID;
        this.assignmentStart = colony.getDay();
        for (ITriggerReturnData<?> data : triggerReturnData) {
            if (data.getContent() instanceof IQuestGiver && this.questGiver == Integer.MIN_VALUE) {
                this.questGiver = ((ICitizenData)data.getContent()).getId();
                ((ICitizenData)data.getContent()).assignQuest(this);
                continue;
            }
            if (!(data.getContent() instanceof IQuestParticipant)) continue;
            this.questParticipants.add(((ICitizenData)data.getContent()).getId());
            ((ICitizenData)data.getContent()).addQuestParticipation(this);
        }
        IQuestManager.GLOBAL_SERVER_QUESTS.get(questTemplateID).getObjective(this.objectiveProgress).startObjective(this);
    }

    public QuestInstance(IColony colony) {
        this.colony = colony;
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public UUID getAssignedPlayer() {
        return this.assignedPlayer;
    }

    @Override
    public void onStart(Player player, IColony colony) {
        this.assignmentStart = colony.getDay();
        this.assignedPlayer = player.m_20148_();
        colony.getQuestManager().attemptAcceptQuest(this.getId(), player);
    }

    @Override
    public IQuestGiver getQuestGiver() {
        return this.colony.getCitizenManager().getCivilian(this.questGiver);
    }

    @Override
    public int getQuestGiverId() {
        return this.questGiver;
    }

    @Override
    public boolean isValid(IColony colony) {
        if (this.questGiver == Integer.MIN_VALUE || colony.getCitizenManager().getCivilian(this.questGiver) == null) {
            return false;
        }
        for (int participant : this.questParticipants) {
            if (colony.getCitizenManager().getCivilian(participant) != null) continue;
            return false;
        }
        return colony.getDay() - this.assignmentStart < IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questTemplateID).getQuestTimeout();
    }

    @Override
    public ResourceLocation getId() {
        return this.questTemplateID;
    }

    @Override
    public void onDeletion() {
        if (this.questGiver != Integer.MIN_VALUE && this.colony.getCitizenManager().getCivilian(this.questGiver) != null) {
            this.colony.getCitizenManager().getCivilian(this.questGiver).onQuestDeletion(this.getId());
        }
        for (int participant : this.questParticipants) {
            if (this.colony.getCitizenManager().getCivilian(participant) == null) continue;
            this.colony.getCitizenManager().getCivilian(participant).onQuestDeletion(this.getId());
        }
        IQuestTemplate instance = IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questTemplateID);
        if (instance != null && instance.getObjective(this.objectiveProgress) != null) {
            instance.getObjective(this.objectiveProgress).onCancellation(this);
        }
        this.colony.getQuestManager().deleteQuest(this.questTemplateID);
    }

    @Override
    public void advanceObjective(Player player) {
        this.advanceObjective(player, this.objectiveProgress + 1);
    }

    @Override
    public void onWorldLoad() {
        if (this.currentObjectiveInstance != null) {
            IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questTemplateID).getObjective(this.objectiveProgress).onWorldLoad(this);
        }
    }

    @Override
    public IObjectiveInstance advanceObjective(Player player, int nextObjective) {
        IQuestTemplate questData = IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questTemplateID);
        List<Integer> rewards = questData.getObjective(this.objectiveProgress).getRewardUnlocks();
        if (!rewards.isEmpty()) {
            questData.unlockQuestRewards(this.colony, player, this, rewards);
        }
        this.colony.markDirty();
        if (nextObjective == -1) {
            this.onCompletion();
            return null;
        }
        if (this.objectiveProgress == 0) {
            this.onStart(player, this.getColony());
        }
        this.objectiveProgress = nextObjective;
        if (this.objectiveProgress >= questData.getObjectiveCount()) {
            this.onCompletion();
            return null;
        }
        this.currentObjectiveInstance = questData.getObjective(this.objectiveProgress).startObjective(this);
        return this.currentObjectiveInstance;
    }

    @Override
    public void onCompletion() {
        this.colony.getQuestManager().completeQuest(this.getId());
        ICitizenData questGiverData = this.colony.getCitizenManager().getCivilian(this.questGiver);
        if (questGiverData != null) {
            questGiverData.onQuestCompletion(this.questTemplateID);
        }
        for (int partId : this.questParticipants) {
            ICitizenData partData = this.colony.getCitizenManager().getCivilian(partId);
            if (partData == null) continue;
            partData.onQuestCompletion(this.questTemplateID);
        }
        Player player = this.colony.getWorld().m_46003_(this.assignedPlayer);
        if (player != null) {
            IQuestTemplate questData = IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questTemplateID);
            player.m_213846_((Component)Component.m_237110_((String)"com.minecolonies.coremod.quest.completed", (Object[])new Object[]{questData.getName()}));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128359_("id", this.questTemplateID.toString());
        compoundNBT.m_128405_("assignstartquest", this.assignmentStart);
        compoundNBT.m_128405_("progress", this.objectiveProgress);
        compoundNBT.m_128405_("questgiver", this.questGiver);
        ListTag participantList = new ListTag();
        for (int citizenData : this.questParticipants) {
            participantList.add((Object)IntTag.m_128679_((int)citizenData));
        }
        compoundNBT.m_128365_("questparticps", (Tag)participantList);
        if (this.currentObjectiveInstance != null) {
            compoundNBT.m_128365_("objective", this.currentObjectiveInstance.serializeNBT());
        }
        if (this.assignedPlayer != null) {
            compoundNBT.m_128362_("player", this.assignedPlayer);
        }
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        IObjectiveInstance data;
        this.questTemplateID = new ResourceLocation(nbt.m_128461_("id"));
        this.assignmentStart = nbt.m_128451_("assignstartquest");
        this.objectiveProgress = nbt.m_128451_("progress");
        this.questGiver = nbt.m_128451_("questgiver");
        ListTag participantList = nbt.m_128437_("questparticps", 3);
        for (Tag tag : participantList) {
            this.questParticipants.add(((IntTag)tag).m_7047_());
        }
        if (nbt.m_128441_("objective") && (data = IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questTemplateID).getObjective(this.objectiveProgress).createObjectiveInstance()) != null) {
            data.deserializeNBT((Tag)nbt.m_128469_("objective"));
            this.currentObjectiveInstance = data;
        }
        if (nbt.m_128441_("player")) {
            this.assignedPlayer = nbt.m_128342_("player");
        }
    }

    @Override
    public int getIndex() {
        return this.objectiveProgress;
    }

    @Override
    public IQuestParticipant getParticipant(int target) {
        return this.colony.getCitizenManager().getCivilian(this.questParticipants.get(target - 1));
    }

    @Override
    public List<Integer> getParticipants() {
        return this.questParticipants;
    }

    @Override
    @Nullable
    public IObjectiveInstance getCurrentObjectiveInstance() {
        return this.currentObjectiveInstance;
    }
}

