/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.university;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TryResearchMessage
extends AbstractBuildingServerMessage<BuildingUniversity> {
    private ResourceLocation researchId;
    private ResourceLocation branch;
    private boolean reset;

    public TryResearchMessage() {
    }

    public TryResearchMessage(IBuildingView building, @NotNull ResourceLocation researchId, ResourceLocation branch, boolean reset) {
        super(building);
        this.researchId = researchId;
        this.branch = branch;
        this.reset = reset;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.researchId = buf.m_130281_();
        this.branch = buf.m_130281_();
        this.reset = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.m_130085_(this.researchId);
        buf.m_130085_(this.branch);
        buf.writeBoolean(this.reset);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, BuildingUniversity building) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, this.researchId);
        if (this.reset) {
            if (colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId) != null) {
                colony.getResearchManager().getResearchTree().attemptResetResearch((Player)player, colony, colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId));
            }
        } else if (research.canResearch(building.getBuildingLevel() == building.getMaxBuildingLevel() ? Integer.MAX_VALUE : building.getBuildingLevel(), colony.getResearchManager().getResearchTree()) || player.m_7500_()) {
            colony.getResearchManager().getResearchTree().attemptBeginResearch((Player)player, colony, research);
        }
    }
}

