/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.event.ColonyInformationChangedEvent;
import com.minecolonies.coremod.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TeamColonyColorChangeMessage
extends AbstractColonyServerMessage {
    private int colorOrdinal;

    public TeamColonyColorChangeMessage() {
    }

    public TeamColonyColorChangeMessage(int colorOrdinal, @NotNull IBuildingView building) {
        super(building.getColony());
        this.colorOrdinal = colorOrdinal;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.colorOrdinal = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colorOrdinal);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        colony.setColonyColor(ChatFormatting.values()[this.colorOrdinal]);
        if (isLogicalServer) {
            MinecraftForge.EVENT_BUS.post((Event)new ColonyInformationChangedEvent(colony, ColonyInformationChangedEvent.Type.TEAM_COLOR));
        }
    }
}

