/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.event.ColonyDeletedEvent;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.MessageUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ColonyDeleteOwnMessage
implements IMessage {
    @Override
    public void toBytes(FriendlyByteBuf buf) {
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        IColony colony = IColonyManager.getInstance().getIColonyByOwner(player.f_19853_, (Player)player);
        if (colony != null) {
            IColonyManager.getInstance().deleteColonyByDimension(colony.getID(), false, colony.getDimension());
            MessageUtils.format("com.minecolonies.coremod.gui.colony.delete.success", new Object[0]).sendTo(new Player[]{player});
            if (isLogicalServer) {
                MinecraftForge.EVENT_BUS.post((Event)new ColonyDeletedEvent(colony));
            }
        } else {
            MessageUtils.format("com.minecolonies.coremod.colony.notfound", new Object[0]).sendTo(new Player[]{player});
        }
    }
}

