/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.loot;

import com.google.common.base.Suppliers;
import com.minecolonies.coremod.MineColonies;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class SupplyLoot
extends LootModifier {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"minecolonies");
    public static final Supplier<Codec<SupplyLoot>> SHIP_CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SupplyLoot.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, co -> new SupplyLoot((LootItemCondition[])co, false))));
    public static final Supplier<Codec<SupplyLoot>> CAMP_CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SupplyLoot.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, co -> new SupplyLoot((LootItemCondition[])co, true))));
    public static final RegistryObject<Codec<SupplyLoot>> SUPPLYSHIP_LOOT = GLM.register("supplyship_loot", SHIP_CODEC);
    public static final RegistryObject<Codec<SupplyLoot>> SUPPLYCAMP_LOOT = GLM.register("supplycamp_loot", CAMP_CODEC);
    public static final ResourceLocation SUPPLY_CAMP_LT = new ResourceLocation("minecolonies", "chests/supplycamp");
    public static final ResourceLocation SUPPLY_SHIP_LT = new ResourceLocation("minecolonies", "chests/supplyship");
    private final boolean camp;
    private Map<ResourceLocation, ResourceLocation> lootTables = new HashMap<ResourceLocation, ResourceLocation>();

    public SupplyLoot(LootItemCondition[] conditionsIn, boolean camp) {
        super(conditionsIn);
        this.camp = camp;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        if (((Boolean)MineColonies.getConfig().getCommon().generateSupplyLoot.get()).booleanValue() && !lootContext.getQueriedLootTableId().m_135827_().equals("minecolonies")) {
            if (this.camp) {
                LootTable stingerLootTable = lootContext.m_78952_().m_7654_().m_278653_().m_278676_(SUPPLY_CAMP_LT);
                stingerLootTable.m_79131_(lootContext, arg_0 -> generatedLoot.add(arg_0));
            } else {
                LootTable stingerLootTable = lootContext.m_78952_().m_7654_().m_278653_().m_278676_(SUPPLY_SHIP_LT);
                stingerLootTable.m_79131_(lootContext, arg_0 -> generatedLoot.add(arg_0));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return this.camp ? CAMP_CODEC.get() : SHIP_CODEC.get();
    }
}

