/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemScepterLumberjack
extends AbstractItemMinecolonies
implements IBlockOverlayItem {
    private static final int RED_OVERLAY = -65536;
    private static final int GREEN_OVERLAY = -16711936;
    private static final String NBT_START_POS = "minecolonies:start_pos";
    private static final String NBT_END_POS = "minecolonies:end_pos";

    public ItemScepterLumberjack(Item.Properties properties) {
        super("scepterlumberjack", properties.m_41487_(1));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.FAIL;
        }
        ItemStack scepter = context.m_43723_().m_21120_(context.m_43724_());
        MessageUtils.format("item.minecolonies.scepterlumberjack.usedstart", new Object[0]).sendTo(context.m_43723_());
        BlockPosUtil.write(scepter.m_41784_(), NBT_START_POS, context.m_8083_());
        this.storeRestrictedArea(context.m_43723_(), scepter.m_41784_(), context.m_43725_());
        return InteractionResult.FAIL;
    }

    public boolean m_6777_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player) {
        if (!world.f_46443_) {
            ItemStack tool = player.m_21205_();
            MessageUtils.format("item.minecolonies.scepterlumberjack.usedend", new Object[0]).sendTo(player);
            BlockPosUtil.write(tool.m_41784_(), NBT_END_POS, pos);
            this.storeRestrictedArea(player, tool.m_41784_(), world);
        }
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return Float.MAX_VALUE;
    }

    private void storeRestrictedArea(Player player, CompoundTag compound, Level worldIn) {
        int maxVolume;
        int maxZ;
        int distZ;
        int maxY;
        int distY;
        Box box = this.getBox(worldIn, compound);
        if (box.anchor() == null || box.corners() == null) {
            return;
        }
        assert (box.corners().getA() != null && box.corners().getB() != null);
        int minX = Math.min(box.corners().getA().m_123341_(), box.corners().getB().m_123341_());
        int minY = Math.min(box.corners().getA().m_123342_(), box.corners().getB().m_123342_());
        int minZ = Math.min(box.corners().getA().m_123343_(), box.corners().getB().m_123343_());
        int maxX = Math.max(box.corners().getA().m_123341_(), box.corners().getB().m_123341_());
        int distX = maxX - minX;
        int volume = distX * (distY = (maxY = Math.max(box.corners().getA().m_123342_(), box.corners().getB().m_123342_())) - minY) * (distZ = (maxZ = Math.max(box.corners().getA().m_123343_(), box.corners().getB().m_123343_())) - minZ);
        if (volume > (maxVolume = (int)Math.floor(2.0 * Math.pow(50.0, 3.0)))) {
            MessageUtils.format("item.minecolonies.scepterlumberjack.restrictiontoobig", volume, maxVolume).sendTo(player);
            return;
        }
        MessageUtils.format("item.minecolonies.scepterlumberjack.restrictionset", minX, maxX, minY, maxY, minZ, maxZ, volume, maxVolume).sendTo(player);
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.m_128451_("id"), worldIn);
        BuildingLumberjack hut = colony.getBuildingManager().getBuilding(box.anchor(), BuildingLumberjack.class);
        if (hut == null) {
            return;
        }
        hut.setRestrictedArea(box.corners().getA(), box.corners().getB());
    }

    @Override
    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        Box box = this.getBox(world, stack.m_41784_());
        if (box.anchor() != null) {
            IBlockOverlayItem.OverlayBox anchorBox = new IBlockOverlayItem.OverlayBox(new AABB(box.anchor()), -65536, 0.02f, true);
            if (box.corners() != null) {
                assert (box.corners().getA() != null && box.corners().getB() != null);
                AABB bounds = new AABB(box.corners().getA(), box.corners().getB().m_7918_(1, 1, 1)).m_82400_(1.0);
                return List.of(anchorBox, new IBlockOverlayItem.OverlayBox(bounds, -16711936, 0.02f, true));
            }
            return Collections.singletonList(anchorBox);
        }
        return Collections.emptyList();
    }

    @NotNull
    private Box getBox(@NotNull Level world, CompoundTag compound) {
        IBuilding iBuilding;
        BlockPos end;
        int colonyId = compound.m_128451_("id");
        BlockPos pos = BlockPosUtil.read(compound, "pos");
        BlockPos start = compound.m_128441_(NBT_START_POS) ? BlockPosUtil.read(compound, NBT_START_POS) : null;
        BlockPos blockPos = end = compound.m_128441_(NBT_END_POS) ? BlockPosUtil.read(compound, NBT_END_POS) : null;
        if (world.m_5776_()) {
            return this.getBox(world, colonyId, pos, start, end);
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, world);
        if (colony != null && (iBuilding = colony.getBuildingManager().getBuilding(pos)) instanceof BuildingLumberjack) {
            BlockPos endRestriction;
            BuildingLumberjack hut = (BuildingLumberjack)iBuilding;
            BlockPos startRestriction = start != null ? start : hut.getStartRestriction();
            BlockPos blockPos2 = endRestriction = end != null ? end : hut.getEndRestriction();
            if (!startRestriction.equals((Object)BlockPos.f_121853_) && !endRestriction.equals((Object)BlockPos.f_121853_)) {
                return new Box(pos, new Tuple<BlockPos, BlockPos>(startRestriction, endRestriction));
            }
            return new Box(pos, null);
        }
        return new Box(null, null);
    }

    @NotNull
    private Box getBox(@NotNull Level world, int colonyId, @NotNull BlockPos pos, @Nullable BlockPos start, @Nullable BlockPos end) {
        IBuildingView iBuildingView;
        IColonyView colony = IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)world.m_46472_());
        if (colony != null && (iBuildingView = colony.getBuilding(pos)) instanceof BuildingLumberjack.View) {
            BlockPos endRestriction;
            BuildingLumberjack.View hut = (BuildingLumberjack.View)iBuildingView;
            BlockPos startRestriction = start != null ? start : hut.getStartRestriction();
            BlockPos blockPos = endRestriction = end != null ? end : hut.getEndRestriction();
            if (!startRestriction.equals((Object)BlockPos.f_121853_) && !endRestriction.equals((Object)BlockPos.f_121853_)) {
                return new Box(pos, new Tuple<BlockPos, BlockPos>(startRestriction, endRestriction));
            }
            return new Box(pos, null);
        }
        return new Box(null, null);
    }

    private record Box(@Nullable BlockPos anchor, @Nullable Tuple<BlockPos, BlockPos> corners) {
    }
}

