/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemResourceScroll
extends AbstractItemMinecolonies {
    public ItemResourceScroll(Item.Properties properties) {
        super("resourcescroll", properties.m_41487_(64));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack scroll = ctx.m_43723_().m_21120_(ctx.m_43724_());
        CompoundTag compound = ItemResourceScroll.checkForCompound(scroll);
        BlockEntity entity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (entity instanceof TileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding buildingEntity = (AbstractTileEntityColonyBuilding)entity;
            if (buildingEntity.getBuilding() instanceof BuildingBuilder) {
                compound.m_128405_("colony", buildingEntity.getColonyId());
                BlockPosUtil.write(compound, "builder", buildingEntity.getPosition());
                if (!ctx.m_43725_().f_46443_) {
                    MessageUtils.format("com.minecolonies.coremod.item.scroll.registered", buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
                }
            } else if (buildingEntity instanceof TileEntityWareHouse) {
                if (ctx.m_43725_().f_46443_) {
                    ItemResourceScroll.openWindow(compound, ctx.m_43723_(), buildingEntity.getPosition());
                }
            } else if (!ctx.m_43725_().f_46443_) {
                MutableComponent buildingTypeComponent = MessageUtils.format(buildingEntity.getBuilding().getBuildingType().getTranslationKey(), new Object[0]).create();
                MessageUtils.format("com.minecolonies.coremod.item.scroll.wrong_building", buildingTypeComponent, buildingEntity.getColony().getName()).sendTo(ctx.m_43723_());
            }
        } else if (ctx.m_43725_().f_46443_) {
            ItemResourceScroll.openWindow(compound, ctx.m_43723_(), null);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack clipboard = playerIn.m_21120_(hand);
        if (!worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
        }
        ItemResourceScroll.openWindow(ItemResourceScroll.checkForCompound(clipboard), playerIn, null);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IBuildingView buildingView;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (worldIn == null) {
            return;
        }
        CompoundTag compound = ItemResourceScroll.checkForCompound(stack);
        int colonyId = compound.m_128451_("colony");
        BlockPos builderPos = BlockPosUtil.read(compound, "builder");
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(colonyId, (ResourceKey<Level>)worldIn.m_46472_());
        if (colonyView != null && (buildingView = colonyView.getBuilding(builderPos)) instanceof BuildingBuilder.View) {
            String name = ((BuildingBuilder.View)buildingView).getWorkerName();
            tooltip.add((Component)(name != null && !name.trim().isEmpty() ? Component.m_237113_((String)(ChatFormatting.DARK_PURPLE + name)) : Component.m_237115_((String)"com.minecolonies.coremod.item.scroll.no_builder")));
        }
    }

    private static CompoundTag checkForCompound(ItemStack item) {
        if (!item.m_41782_()) {
            item.m_41751_(new CompoundTag());
        }
        return item.m_41783_();
    }

    private static void openWindow(CompoundTag compound, Player player, BlockPos warehousePos) {
        if (compound.m_128441_("colony") && compound.m_128441_("builder")) {
            int colonyId = compound.m_128451_("colony");
            BlockPos builderPos = BlockPosUtil.read(compound, "builder");
            MineColonies.proxy.openResourceScrollWindow(colonyId, builderPos, warehousePos, compound);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"com.minecolonies.coremod.item.scroll.needcolony"), true);
        }
    }
}

