/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.minecolonies.api.util.Log;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourcePackLoader;
import org.jetbrains.annotations.NotNull;

public class DefaultEntityIconProvider
implements DataProvider {
    private final DataGenerator generator;

    public DefaultEntityIconProvider(@NotNull DataGenerator generator) {
        this.generator = generator;
    }

    @NotNull
    public String m_6055_() {
        return "Default Citizen Icons";
    }

    private static boolean IsEntitySkin(@NotNull ResourceLocation id) {
        return id.m_135815_().endsWith(".png") && (id.m_135815_().startsWith("textures/entity/citizen/") || id.m_135815_().startsWith("textures/entity/raiders/"));
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        PackOutput.PathProvider outputProvider = this.generator.getPackOutput().m_245269_(PackOutput.Target.RESOURCE_PACK, "textures/entity_icon");
        IModFileInfo modFileInfo = ModList.get().getModFileById("minecolonies");
        try (PathPackResources pack = ResourcePackLoader.createPackForMod((IModFileInfo)modFileInfo);){
            ArrayList icons = new ArrayList();
            pack.m_8031_(PackType.CLIENT_RESOURCES, "minecolonies", "textures/entity", (id, stream) -> {
                if (DefaultEntityIconProvider.IsEntitySkin(id)) {
                    ResourceLocation iconId = new ResourceLocation(id.m_135827_(), id.m_135815_().replace("textures/entity/", "").replace(".png", ""));
                    icons.add(this.generateIcon(outputProvider, iconId, (IoSupplier<InputStream>)stream, cache));
                }
            });
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf((CompletableFuture[])icons.toArray(CompletableFuture[]::new));
            return completableFuture;
        }
    }

    private CompletableFuture<?> generateIcon(@NotNull PackOutput.PathProvider outputProvider, @NotNull ResourceLocation id, @NotNull IoSupplier<InputStream> inputSupplier, @NotNull CachedOutput cache) {
        return CompletableFuture.runAsync(() -> {
            try (NativeImage skin = NativeImage.m_85058_((InputStream)((InputStream)inputSupplier.m_247737_()));
                 NativeImage icon = DefaultEntityIconProvider.createIconForSkin(skin);){
                DefaultEntityIconProvider.saveIcon(outputProvider, id, icon, cache);
            }
            catch (IOException e) {
                Log.getLogger().error("Failed to save file to {}", (Object)id, (Object)e);
            }
        }, Util.m_183991_());
    }

    private static NativeImage createIconForSkin(@NotNull NativeImage skin) {
        NativeImage icon = new NativeImage(16, 16, false);
        skin.m_85034_(8, 8, 8, 8, icon);
        for (int i = 0; i < 16; ++i) {
            icon.m_166411_(0, i, Integer.MIN_VALUE);
            icon.m_166411_(15, i, Integer.MIN_VALUE);
            if (i <= 0 || i >= 15) continue;
            icon.m_166411_(i, 0, Integer.MIN_VALUE);
            icon.m_166411_(i, 15, Integer.MIN_VALUE);
        }
        return icon;
    }

    private static void saveIcon(@NotNull PackOutput.PathProvider outputProvider, @NotNull ResourceLocation id, @NotNull NativeImage icon, @NotNull CachedOutput cache) throws IOException {
        BufferedImage image;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(icon.m_85121_());){
            image = ImageIO.read(stream);
        }
        BufferedImage optimized = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        optimized.getGraphics().drawImage(image, 0, 0, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HashingOutputStream hashStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)outputStream);
        ImageIO.write((RenderedImage)optimized, "PNG", (OutputStream)hashStream);
        cache.m_213871_(outputProvider.m_245527_(id, "png"), outputStream.toByteArray(), hashStream.hash());
    }
}

