/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.coremod.generation.IJsonSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class SoundsJson
implements IJsonSerializable {
    @NotNull
    private Map<String[], List<String>> sounds = new TreeMap<String[], List<String>>();

    public SoundsJson() {
    }

    public SoundsJson(@NotNull Map<String[], List<String>> sounds) {
        this.sounds = SoundsJson.ensureTreeMap(sounds);
    }

    public static <K, V> Map<K, V> ensureTreeMap(Map<K, V> map) {
        return map instanceof TreeMap ? map : new TreeMap(map);
    }

    public static JsonObject createSoundJson(String category, JsonObject properties, List<String> names) {
        JsonObject sound = new JsonObject();
        sound.addProperty("category", category);
        JsonArray containedSoundList = new JsonArray();
        for (String name : names) {
            JsonObject sound1 = new JsonObject();
            sound1.addProperty("name", name);
            for (Map.Entry entry : properties.entrySet()) {
                sound1.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            containedSoundList.add((JsonElement)sound1);
        }
        sound.add("sounds", (JsonElement)containedSoundList);
        return sound;
    }

    @Override
    @NotNull
    public JsonElement serialize() {
        JsonObject returnValue = new JsonObject();
        for (Map.Entry<String[], List<String>> entry : this.sounds.entrySet()) {
            JsonObject defaultValue = new JsonObject();
            defaultValue.addProperty("category", entry.getKey()[1]);
            JsonArray sounds = new JsonArray();
            for (String value : entry.getValue()) {
                JsonObject sound1 = new JsonObject();
                sound1.addProperty("name", value);
                sound1.addProperty("stream", Boolean.valueOf(false));
                sounds.add((JsonElement)sound1);
            }
            defaultValue.add("sounds", (JsonElement)sounds);
            returnValue.add(entry.getKey()[0], (JsonElement)defaultValue);
        }
        return returnValue;
    }

    @Override
    public void deserialize(@NotNull JsonElement jsonElement) {
        JsonObject soundsJson = jsonElement.getAsJsonObject();
        for (Map.Entry soundEntry : soundsJson.entrySet()) {
            String key = (String)soundEntry.getKey();
            JsonObject entryJson = ((JsonElement)soundEntry.getValue()).getAsJsonObject();
            String category = entryJson.get("category").getAsString();
            ArrayList<String> sounds = new ArrayList<String>();
            JsonArray array = entryJson.getAsJsonArray("sounds");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                sounds.add(obj.get("name").getAsString());
            }
            this.sounds.put(new String[]{key, category}, sounds);
        }
    }
}

