/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.pathfinding.MNode;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob {
    @NotNull
    protected final BlockPos avoid;
    protected final int avoidDistance;
    private BlockPos preferredDirection;

    public PathJobMoveAwayFromLocation(Level world, @NotNull BlockPos start, @NotNull BlockPos avoid, int avoidDistance, int range, LivingEntity entity) {
        super(world, start, avoid, range, entity);
        IColony colony;
        this.avoid = new BlockPos((Vec3i)avoid);
        this.avoidDistance = avoidDistance;
        this.preferredDirection = entity.m_20183_().m_121955_((Vec3i)entity.m_20183_().m_121996_((Vec3i)avoid).m_142393_(range));
        if (entity instanceof AbstractEntityCitizen && (colony = ((AbstractEntityCitizen)entity).getCitizenColonyHandler().getColony()) != null) {
            this.preferredDirection = colony.getCenter();
        }
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.m_123341_(), this.start.m_123342_(), this.start.m_123343_(), this.avoid.m_123341_(), this.avoid.m_123342_(), this.avoid.m_123343_()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        return Math.sqrt(this.preferredDirection.m_123331_((Vec3i)pos)) + 100.0 / Math.max(1.0, Math.sqrt(this.avoid.m_123331_((Vec3i)pos)));
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return Math.sqrt(this.avoid.m_123331_((Vec3i)n.pos)) > (double)this.avoidDistance;
    }

    @Override
    protected double getNodeResultScore(@NotNull MNode n) {
        return -this.avoid.m_123331_((Vec3i)n.pos);
    }
}

