/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.interactionhandling.SimpleNotificationInteraction;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CitizenSleepHandler
implements ICitizenSleepHandler {
    private static final double Y_DIFF_WEIGHT = 1.5;
    private static final double TIME_PER_BLOCK = 6.0;
    private static final double MAX_NO_COMPLAIN_DISTANCE = 160.0;
    private final AbstractEntityCitizen citizen;

    public CitizenSleepHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public boolean isAsleep() {
        return (Boolean)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_IS_ASLEEP);
    }

    private void setIsAsleep(boolean isAsleep) {
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setAsleep(isAsleep);
        }
        this.citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_IS_ASLEEP, (Object)isAsleep);
    }

    @Override
    public boolean trySleep(BlockPos bedLocation) {
        boolean isBed;
        BlockState state = WorldUtil.isEntityBlockLoaded((LevelAccessor)this.citizen.f_19853_, bedLocation) ? this.citizen.f_19853_.m_8055_(bedLocation) : null;
        boolean bl = isBed = state != null && state.m_60734_().isBed(state, (BlockGetter)this.citizen.f_19853_, bedLocation, (Entity)this.citizen);
        if (!isBed) {
            return false;
        }
        this.citizen.m_20124_(Pose.SLEEPING);
        this.citizen.getNavigation().m_26573_();
        double zOffset = ((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122434_() == Direction.Axis.Z && this.citizen.getCitizenData().isChild() ? 0.0 : 0.5;
        double xOffset = ((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122434_() == Direction.Axis.X && this.citizen.getCitizenData().isChild() ? 0.0 : 0.5;
        this.citizen.m_6034_((double)bedLocation.m_123341_() + xOffset, (double)bedLocation.m_123342_() + 0.6875, (double)bedLocation.m_123343_() + zOffset);
        this.citizen.m_21250_(bedLocation);
        this.citizen.m_20256_(Vec3.f_82478_);
        this.citizen.f_19812_ = true;
        this.citizen.getCitizenItemHandler().removeHeldItem();
        this.setIsAsleep(true);
        this.citizen.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.sleeping"), ChatPriority.HIDDEN));
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(bedLocation);
        }
        this.citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_BED_POS, (Object)bedLocation);
        this.citizen.getCitizenData().getColony().getCitizenManager().onCitizenSleep();
        return true;
    }

    @Override
    public void onWakeUp() {
        this.notifyCitizenHandlersOfWakeUp();
        if (this.isAsleep()) {
            this.spawnCitizenFromBed();
        }
        this.citizen.m_20124_(Pose.STANDING);
        this.citizen.m_21258_();
        this.setIsAsleep(false);
    }

    private void notifyCitizenHandlersOfWakeUp() {
        IBuilding homeBuilding;
        if (this.citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
            this.citizen.getCitizenColonyHandler().getWorkBuilding().onWakeUp();
        }
        if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            this.citizen.getCitizenJobHandler().getColonyJob().onWakeUp();
        }
        if ((homeBuilding = this.citizen.getCitizenColonyHandler().getHomeBuilding()) != null) {
            homeBuilding.onWakeUp();
        }
    }

    private void spawnCitizenFromBed() {
        BlockPos relPos;
        BlockState lowerState;
        BlockState bedState;
        BlockState blockState = bedState = this.getBedLocation().equals((Object)BlockPos.f_121853_) ? null : this.citizen.f_19853_.m_8055_(this.getBedLocation());
        BlockPos spawn = !this.getBedLocation().equals((Object)BlockPos.f_121853_) && bedState.m_204336_(BlockTags.f_13038_) ? (bedState.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? ((lowerState = this.citizen.f_19853_.m_8055_(relPos = this.getBedLocation().m_121945_(((Direction)bedState.m_61143_((Property)BedBlock.f_54117_)).m_122424_()))).m_204336_(BlockTags.f_13038_) && lowerState.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT ? EntityUtils.getSpawnPoint(this.citizen.f_19853_, relPos) : EntityUtils.getSpawnPoint(this.citizen.f_19853_, this.getBedLocation())) : EntityUtils.getSpawnPoint(this.citizen.f_19853_, this.getBedLocation())) : this.citizen.m_20183_();
        if (spawn != null && !spawn.equals((Object)BlockPos.f_121853_)) {
            this.citizen.m_6034_((double)spawn.m_123341_() + 0.5, spawn.m_123342_(), (double)spawn.m_123343_() + 0.5);
        }
        this.setIsAsleep(false);
        if (this.citizen.getCitizenData() != null) {
            this.citizen.getCitizenData().setBedPos(new BlockPos(0, 0, 0));
        }
        this.citizen.m_20088_().m_135381_(AbstractEntityCitizen.DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
    }

    @Override
    public BlockPos findHomePos() {
        BlockPos pos = this.citizen.m_21534_();
        if (pos.equals((Object)BlockPos.f_121853_)) {
            if (this.citizen.getCitizenColonyHandler().getColony().hasTownHall()) {
                return this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getTownHall().getPosition();
            }
            return this.citizen.getCitizenColonyHandler().getColony().getCenter();
        }
        return pos;
    }

    @Override
    public BlockPos getBedLocation() {
        return (BlockPos)this.citizen.m_20088_().m_135370_(AbstractEntityCitizen.DATA_BED_POS);
    }

    @Override
    public boolean shouldGoSleep() {
        BlockPos homePos = this.findHomePos();
        BlockPos citizenPos = this.citizen.m_20183_();
        int additionalDist = 0;
        if (this.citizen.m_20145_()) {
            return false;
        }
        if (this.citizen.getCitizenData().getJob() instanceof JobMiner && this.citizen.getCitizenData().getWorkBuilding().getPosition().m_123342_() - 20 > citizenPos.m_123342_()) {
            BlockPos workPos = this.citizen.getCitizenData().getWorkBuilding().getID();
            additionalDist = (int)BlockPosUtil.getDistance2D(citizenPos, workPos) + Math.abs(citizenPos.m_123342_() - workPos.m_123342_()) * 3;
            citizenPos = workPos;
        }
        int xDiff = Math.abs(homePos.m_123341_() - citizenPos.m_123341_());
        int zDiff = Math.abs(homePos.m_123343_() - citizenPos.m_123343_());
        int yDiff = (int)((double)Math.abs(homePos.m_123342_() - citizenPos.m_123342_()) * 1.5);
        double timeNeeded = (Math.sqrt(xDiff * xDiff + zDiff * zDiff + yDiff * yDiff) + (double)additionalDist) * 6.0;
        double timeLeft = (this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WORK_LONGER) == 0.0 ? 12600.0 : 12600.0 + this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WORK_LONGER) * 1000.0) - (double)(this.citizen.f_19853_.m_46468_() % 24000L);
        if (timeLeft <= 0.0 || timeLeft - timeNeeded <= 0.0) {
            double workHomeDistance;
            if (this.citizen.getCitizenData().getWorkBuilding() != null && (workHomeDistance = Math.sqrt(BlockPosUtil.getDistanceSquared(homePos, this.citizen.getCitizenData().getWorkBuilding().getID()))) > 160.0) {
                this.citizen.getCitizenData().triggerInteraction(new SimpleNotificationInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.chat.hometoofar"), ChatPriority.IMPORTANT));
            }
            return true;
        }
        return false;
    }
}

