/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.event.BuildingConstructionEvent;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingBuiltEvent;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingDeconstructedEvent;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingRepairedEvent;
import com.minecolonies.coremod.colony.colonyEvents.buildingEvents.BuildingUpgradedEvent;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.entity.ai.util.WorkerLoadOnlyStructureHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructureWithWorkOrder<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractEntityAIStructure<J, B> {
    protected RequestStage requestState = RequestStage.SOLID;
    protected BlockPos requestProgress = null;
    private boolean recalculated = false;

    public AbstractEntityAIStructureWithWorkOrder(@NotNull J job) {
        super(job);
        this.worker.m_21553_(true);
    }

    @Override
    public void storeProgressPos(BlockPos blockPos, BuildingStructureHandler.Stage stage) {
        ((AbstractBuildingStructureBuilder)this.building).setProgressPos(blockPos, stage);
    }

    @Override
    public Tuple<BlockPos, BuildingStructureHandler.Stage> getProgressPos() {
        return ((AbstractBuildingStructureBuilder)this.building).getProgress();
    }

    @Override
    public IAIState loadRequirements() {
        if (this.loadingBlueprint) {
            return this.getState();
        }
        if (!((AbstractJobStructure)this.job).hasBlueprint() || this.structurePlacer == null) {
            this.loadStructure();
            IWorkOrder wo = ((AbstractJobStructure)this.job).getWorkOrder();
            if (wo == null) {
                Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()), (Throwable)new Exception());
                ((AbstractJobStructure)this.job).setWorkOrder(null);
                return AIWorkerState.IDLE;
            }
            if (wo instanceof WorkOrderBuilding) {
                IBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getLocation());
                if (building == null) {
                    Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Starting and missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getLocation()), (Throwable)new Exception());
                    return AIWorkerState.IDLE;
                }
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildstart", ((AbstractJobStructure)this.job).getWorkOrder().getDisplayName());
                if (building.getBuildingLevel() > 0) {
                    wo.setCleared(true);
                }
            } else if (!(wo instanceof WorkOrderMiner)) {
                this.worker.getCitizenChatHandler().sendLocalizedChat("entity.builder.messagebuildstart", ((AbstractJobStructure)this.job).getWorkOrder().getDisplayName());
            }
            return this.getState();
        }
        if (((AbstractJobStructure)this.job).getWorkOrder().isRequested()) {
            return this.afterStructureLoading();
        }
        this.requestMaterialsState();
        return this.getState();
    }

    private void loadStructure() {
        IWorkOrder workOrder = ((AbstractJobStructure)this.job).getWorkOrder();
        if (workOrder == null) {
            return;
        }
        BlockPos pos = workOrder.getLocation();
        if (workOrder instanceof WorkOrderBuilding && this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(pos) == null) {
            Log.getLogger().warn("AbstractBuilding does not exist - removing build request");
            this.worker.getCitizenColonyHandler().getColony().getWorkManager().removeWorkOrder(workOrder);
            return;
        }
        int tempRotation = workOrder.getRotation();
        boolean removal = workOrder.getWorkOrderType() == WorkOrderType.REMOVE;
        this.loadStructure(workOrder.getStructurePack(), workOrder.getStructurePath(), tempRotation, pos, workOrder.isMirrored(), removal);
        workOrder.setCleared(false);
        workOrder.setRequested(removal);
    }

    private void requestMaterialsState() {
        if (Constants.BUILDER_INF_RESOURECES || ((AbstractJobStructure)this.job).getWorkOrder().isRequested() || ((AbstractJobStructure)this.job).getWorkOrder().getWorkOrderType() == WorkOrderType.REMOVE) {
            this.recalculated = true;
            return;
        }
        AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.building;
        if (this.requestMaterials()) {
            ((AbstractJobStructure)this.job).getWorkOrder().setRequested(true);
        }
        int newQuantity = buildingWorker.getNeededResources().values().stream().mapToInt(ItemStorage::getAmount).sum();
        if (((AbstractJobStructure)this.job).getWorkOrder().getAmountOfResources() == 0 || newQuantity > ((AbstractJobStructure)this.job).getWorkOrder().getAmountOfResources()) {
            ((AbstractJobStructure)this.job).getWorkOrder().setAmountOfResources(newQuantity);
        }
    }

    @Override
    protected IAIState waitForRequests() {
        if (((AbstractJobStructure)this.job).hasWorkOrder() && ((AbstractBuildingStructureBuilder)this.building).getNeededResources().isEmpty() && !this.recalculated && (this.structurePlacer == null || !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint())) {
            return AIWorkerState.START_BUILDING;
        }
        return super.waitForRequests();
    }

    @Override
    public boolean requestMaterials() {
        WorkerLoadOnlyStructureHandler structure = new WorkerLoadOnlyStructureHandler(this.world, ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getWorldPos(), ((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getBluePrint(), new PlacementSettings(), true, this);
        if (((AbstractJobStructure)this.job).getWorkOrder().getIteratorType().isEmpty()) {
            String mode = BuilderModeSetting.getActualValue(this.building);
            ((AbstractJobStructure)this.job).getWorkOrder().setIteratorType(mode);
        }
        StructurePlacer placer = new StructurePlacer(structure, ((AbstractJobStructure)this.job).getWorkOrder().getIteratorType());
        if (this.requestProgress == null) {
            AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.building;
            buildingWorker.resetNeededResources();
            this.requestProgress = AbstractBlueprintIterator.NULL_POS;
            this.requestState = RequestStage.SOLID;
        }
        RequestStage currState = this.requestState;
        switch (currState) {
            case SOLID: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.canBlockFloatInAir((BlockState)info.getBlockInfo().getState()) || AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().m_60734_()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.WEAK_SOLID;
                }
                return false;
            }
            case WEAK_SOLID: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.isWeakSolidBlock((BlockState)info.getBlockInfo().getState()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.DECO;
                }
                return false;
            }
            case DECO: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> BlockUtils.isAnySolid((BlockState)info.getBlockInfo().getState()) && !AbstractEntityAIStructureWithWorkOrder.isDecoItem(info.getBlockInfo().getState().m_60734_()))), false);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.ENTITIES;
                }
                return false;
            }
            case ENTITIES: {
                StructurePhasePlacementResult result = placer.executeStructureStep(this.world, null, this.requestProgress, StructurePlacer.Operation.GET_RES_REQUIREMENTS, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0)), true);
                this.requestProgress = result.getIteratorPos();
                for (ItemStack stack : result.getBlockResult().getRequiredItems()) {
                    ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, stack.m_41613_());
                }
                if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
                    this.requestState = RequestStage.SOLID;
                    this.requestProgress = null;
                    this.recalculated = true;
                    return true;
                }
                return false;
            }
        }
        this.recalculated = true;
        return true;
    }

    @Override
    public void registerBlockAsNeeded(ItemStack stack) {
        int hashCode;
        int n = hashCode = stack.m_41782_() ? stack.m_41783_().hashCode() : 0;
        if (((AbstractBuildingStructureBuilder)this.building).getNeededResources().get(stack.m_41778_() + "-" + hashCode) == null) {
            ((AbstractBuildingStructureBuilder)this.building).addNeededResource(stack, 1);
        }
    }

    @Override
    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        if (ItemStackUtils.isEmpty(deliveredItemStack).booleanValue()) {
            return 0;
        }
        int hashCode = deliveredItemStack.m_41782_() ? deliveredItemStack.m_41783_().hashCode() : 0;
        BuildingBuilderResource resource = ((AbstractBuildingStructureBuilder)this.building).getNeededResources().get(deliveredItemStack.m_41778_() + "-" + hashCode);
        if (resource != null) {
            return resource.getAmount();
        }
        return super.getTotalRequiredAmount(deliveredItemStack);
    }

    @Override
    public void executeSpecificCompleteActions() {
        if (((AbstractJobStructure)this.job).getBlueprint() == null && ((AbstractJobStructure)this.job).hasWorkOrder()) {
            ((AbstractJobStructure)this.job).complete();
        }
        if (((AbstractJobStructure)this.job).getBlueprint() == null) {
            return;
        }
        IWorkOrder wo = ((AbstractJobStructure)this.job).getWorkOrder();
        if (wo == null) {
            Log.getLogger().error(String.format("Worker (%d:%d) ERROR - Finished, but missing work order(%d)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), ((AbstractJobStructure)this.job).getWorkOrderId()));
        } else {
            String workOrderName = wo.getTranslationKey();
            this.sendCompletionMessage(wo);
            switch (wo.getWorkOrderType()) {
                case BUILD: {
                    ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(new BuildingBuiltEvent(wo.getLocation(), workOrderName));
                    this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("build_built");
                    break;
                }
                case UPGRADE: {
                    ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(new BuildingUpgradedEvent(wo.getLocation(), workOrderName, wo.getTargetLevel()));
                    this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("build_upgraded");
                    break;
                }
                case REPAIR: {
                    ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(new BuildingRepairedEvent(wo.getLocation(), workOrderName, wo.getCurrentLevel()));
                    this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("build_repaired");
                    break;
                }
                case REMOVE: {
                    ((AbstractJobStructure)this.job).getColony().getEventDescriptionManager().addEventDescription(new BuildingDeconstructedEvent(wo.getLocation(), workOrderName, wo.getCurrentLevel()));
                    this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("build_removed");
                }
            }
            ((AbstractJobStructure)this.job).complete();
            if (wo instanceof WorkOrderBuilding) {
                IBuilding building = ((AbstractJobStructure)this.job).getColony().getBuildingManager().getBuilding(wo.getLocation());
                MinecraftForge.EVENT_BUS.post((Event)new BuildingConstructionEvent(building, BuildingConstructionEvent.EventType.fromWorkOrderType(wo.getWorkOrderType())));
                switch (wo.getWorkOrderType()) {
                    case BUILD: 
                    case UPGRADE: 
                    case REPAIR: {
                        if (building == null) {
                            Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getLocation()));
                            break;
                        }
                        BlockEntity te = this.worker.f_19853_.m_7702_(building.getID());
                        if (!(te instanceof AbstractTileEntityColonyBuilding) || !((IBlueprintDataProviderBE)te).getSchematicName().isEmpty()) break;
                        building.onUpgradeComplete(wo.getTargetLevel());
                        building.setBuildingLevel(wo.getTargetLevel());
                        break;
                    }
                    case REMOVE: {
                        if (building == null) {
                            Log.getLogger().error(String.format("Builder (%d:%d) ERROR - Finished, but missing building(%s)", this.worker.getCitizenColonyHandler().getColony().getID(), this.worker.getCitizenData().getId(), wo.getLocation()));
                            break;
                        }
                        building.setDeconstructed();
                    }
                }
            }
        }
        ((AbstractBuildingStructureBuilder)this.building).resetNeededResources();
    }

    protected void sendCompletionMessage(IWorkOrder wo) {
    }

    @Override
    public void reduceNeededResources(ItemStack stack) {
        ((AbstractBuildingStructureBuilder)this.building).reduceNeededResource(stack, 1);
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((AbstractJobStructure)this.job).getWorkOrder() == null && ((AbstractJobStructure)this.job).getBlueprint() != null || this.structurePlacer != null && !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint()) {
            ((AbstractJobStructure)this.job).setBlueprint(null);
            if (((AbstractJobStructure)this.job).hasWorkOrder()) {
                ((AbstractJobStructure)this.job).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
            }
            ((AbstractJobStructure)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            ((AbstractBuildingStructureBuilder)this.building).cancelAllRequestsOfCitizen(this.worker.getCitizenData());
            ((AbstractBuildingStructureBuilder)this.building).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return true;
        }
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && !WorldUtil.isBlockLoaded((LevelAccessor)this.world, ((AbstractJobStructure)this.job).getWorkOrder().getLocation()) && this.getState() != AIWorkerState.PICK_UP_RESIDUALS;
    }

    @Override
    protected boolean isAlreadyCleared() {
        return ((AbstractJobStructure)this.job).getWorkOrder() != null && ((AbstractJobStructure)this.job).getWorkOrder().isCleared();
    }

    @Override
    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        int hashCode = stack.m_41782_() ? stack.m_41783_().hashCode() : 0;
        AbstractBuildingStructureBuilder buildingWorker = (AbstractBuildingStructureBuilder)this.building;
        BuildingBuilderResource resource = buildingWorker.getNeededResources().get(stack.m_41778_() + "-" + hashCode);
        if (resource == null) {
            this.requestMaterials();
            resource = buildingWorker.getNeededResources().get(stack.m_41778_() + "-" + hashCode);
        }
        if (resource == null) {
            return stack;
        }
        ItemStack resStack = new ItemStack((ItemLike)resource.getItem(), Math.min(64, resource.getAmount()));
        resStack.m_41751_(resource.getItemStack().m_41783_());
        return resStack;
    }

    @Override
    public void handleSpecificCancelActions() {
        ((AbstractBuildingStructureBuilder)this.building).getColony().getWorkManager().removeWorkOrder(((AbstractJobStructure)this.job).getWorkOrderId());
        ((AbstractJobStructure)this.job).setWorkOrder(null);
    }

    protected static enum RequestStage {
        SOLID,
        WEAK_SOLID,
        DECO,
        ENTITIES;

    }
}

