/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.blocks.schematic.BlockFluidSubstitution;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.modules.BuildingResourcesModule;
import com.minecolonies.coremod.colony.buildings.utils.BuilderBucket;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIStructure<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractEntityAIInteract<J, B> {
    protected Tuple<StructurePlacer, BuildingStructureHandler<J, B>> structurePlacer;
    protected boolean limitReached = false;
    protected boolean loadingBlueprint = false;
    protected TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler> DONT_TOUCH_PREDICATE = (info, worldPos, handler) -> {
        BlockState worldState = handler.getWorld().m_8055_(worldPos);
        return worldState.m_60734_() instanceof IBuilderUndestroyable || worldState.m_60734_() == Blocks.f_50752_ || info.getBlockInfo().getState().m_60734_() instanceof AbstractBlockHut && handler.getWorldPos().equals(worldPos) && worldState.m_60734_() instanceof AbstractBlockHut;
    };
    protected BlockPos workFrom;
    protected BlockPos blockToMine;
    private int pickUpCount = 0;

    protected AbstractEntityAIStructure(@NotNull J job) {
        super(job);
        this.registerTargets(new AITarget<Object>(AIWorkerState.PICK_UP_RESIDUALS, this::pickUpResiduals, 20), new AIEventTarget<AIWorkerState>(AIBlockingEventType.STATE_BLOCKING, this::checkIfCanceled, AIWorkerState.IDLE, 1), new AITarget<Object>(AIWorkerState.LOAD_STRUCTURE, this::loadRequirements, 5), new AITarget<Object>(AIWorkerState.START_BUILDING, this::startBuilding, 1), new AITarget<Object>(AIWorkerState.MINE_BLOCK, this::doMining, 10), new AITarget<Object>(AIWorkerState.IDLE, this::isThereAStructureToBuild, () -> AIWorkerState.START_BUILDING, 100), new AITarget<Object>(AIWorkerState.BUILDING_STEP, this::structureStep, 5), new AITarget<Object>(AIWorkerState.COMPLETE_BUILD, this::completeBuild, 5), new AITarget<Object>(AIWorkerState.PICK_UP, this::pickUpMaterial, 5));
    }

    public IAIState pickUpMaterial() {
        if (this.structurePlacer == null || !this.structurePlacer.getB().hasBluePrint()) {
            return AIWorkerState.IDLE;
        }
        if (this.structurePlacer.getB().getStage() == null || this.structurePlacer.getB().getStage() == BuildingStructureHandler.Stage.CLEAR) {
            this.pickUpCount = 0;
            return AIWorkerState.START_WORKING;
        }
        ArrayList<Tuple<Predicate<ItemStack>, Integer>> neededItemsList = new ArrayList<Tuple<Predicate<ItemStack>, Integer>>();
        BuilderBucket neededRessourcesMap = ((AbstractBuildingStructureBuilder)this.building).getRequiredResources();
        BuildingResourcesModule module = (BuildingResourcesModule)((AbstractBuildingStructureBuilder)this.building).getFirstModuleOccurance(BuildingResourcesModule.class);
        if (neededRessourcesMap != null) {
            for (Map.Entry<String, Integer> entry : neededRessourcesMap.getResourceMap().entrySet()) {
                BuildingBuilderResource res = module.getResourceFromIdentifier(entry.getKey());
                if (res == null) continue;
                int amount = entry.getValue();
                neededItemsList.add(new Tuple<Predicate<ItemStack>, Integer>(itemstack -> ItemStackUtils.compareItemStacksIgnoreStackSize(res.getItemStack(), itemstack, true, true), amount));
            }
        }
        if (neededItemsList.size() <= this.pickUpCount || InventoryUtils.openSlotCount((IItemHandler)this.worker.getInventoryCitizen()) <= 5L) {
            ((AbstractBuildingStructureBuilder)this.building).checkOrRequestBucket(((AbstractBuildingStructureBuilder)this.building).getRequiredResources(), this.worker.getCitizenData(), true);
            ((AbstractBuildingStructureBuilder)this.building).checkOrRequestBucket(((AbstractBuildingStructureBuilder)this.building).getNextBucket(), this.worker.getCitizenData(), false);
            this.pickUpCount = 0;
            return AIWorkerState.START_WORKING;
        }
        this.needsCurrently = (Tuple)neededItemsList.get(this.pickUpCount);
        ++this.pickUpCount;
        if (InventoryUtils.hasItemInProvider((ICapabilityProvider)((AbstractBuildingStructureBuilder)this.building).getTileEntity(), (Predicate)this.needsCurrently.getA())) {
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return AIWorkerState.PICK_UP;
    }

    protected IAIState pickUpResiduals() {
        if (this.structurePlacer != null && this.structurePlacer.getB().getStage() != null) {
            return AIWorkerState.IDLE;
        }
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        this.workFrom = null;
        this.structurePlacer = null;
        return AIWorkerState.IDLE;
    }

    protected IAIState completeBuild() {
        this.incrementActionsDoneAndDecSaturation();
        this.executeSpecificCompleteActions();
        this.worker.getCitizenExperienceHandler().addExperience(8.0);
        return AIWorkerState.PICK_UP_RESIDUALS;
    }

    @NotNull
    protected IAIState startBuilding() {
        if (this.structurePlacer == null || !this.structurePlacer.getB().hasBluePrint()) {
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.BUILDING_STEP;
    }

    public IAIState afterStructureLoading() {
        return AIWorkerState.START_BUILDING;
    }

    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.getWorkingPosition(currentBlock);
        }
        return this.worker.isWorkerAtSiteWithMove(this.workFrom, 5) || MathUtils.twoDimDistance(this.worker.m_20183_(), this.workFrom) < 12.0;
    }

    protected static boolean isDecoItem(Block block) {
        return block.m_49966_().m_204336_(ModTags.decorationItems) || block instanceof BlockFluidSubstitution;
    }

    protected IAIState structureStep() {
        StructurePhasePlacementResult result;
        if (this.structurePlacer.getB().getStage() == null) {
            return AIWorkerState.PICK_UP_RESIDUALS;
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        this.checkForExtraBuildingActions();
        BlockPos progress = this.getProgressPos() == null ? AbstractBlueprintIterator.NULL_POS : this.getProgressPos().getA();
        BlockPos worldPos = this.structurePlacer.getB().getProgressPosInWorld(progress);
        if (this.getProgressPos() != null) {
            this.structurePlacer.getB().setStage(this.getProgressPos().getB());
        }
        if (!(progress.equals((Object)AbstractBlueprintIterator.NULL_POS) && this.blockToMine == null || this.limitReached || !(this.blockToMine == null ? !this.walkToConstructionSite(worldPos) : !this.walkToConstructionSite(this.blockToMine)))) {
            return this.getState();
        }
        this.limitReached = false;
        StructurePlacer placer = this.structurePlacer.getA();
        switch (this.structurePlacer.getB().getStage()) {
            case BUILD_SOLID: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.canBlockFloatInAir((BlockState)info.getBlockInfo().getState()) || AbstractEntityAIStructure.isDecoItem(info.getBlockInfo().getState().m_60734_()))), false);
                break;
            }
            case WEAK_SOLID: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !BlockUtils.isWeakSolidBlock((BlockState)info.getBlockInfo().getState()))), false);
                break;
            }
            case CLEAR_WATER: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.WATER_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().m_8055_(pos).m_60819_().m_76178_()), false);
                break;
            }
            case CLEAR_NON_SOLIDS: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().decrement(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> !(info.getBlockInfo().getState().m_60734_() instanceof AirBlock) || handler.getWorld().m_46859_(pos))), false);
                break;
            }
            case DECORATE: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> BlockUtils.isAnySolid((BlockState)info.getBlockInfo().getState()) && !AbstractEntityAIStructure.isDecoItem(info.getBlockInfo().getState().m_60734_()))), false);
                break;
            }
            case SPAWN: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_PLACEMENT, () -> placer.getIterator().increment(this.DONT_TOUCH_PREDICATE.or((info, pos, handler) -> info.getEntities().length == 0)), true);
                break;
            }
            case REMOVE_WATER: {
                placer.getIterator().setRemoving();
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.WATER_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> info.getBlockInfo().getState().m_60819_().m_76178_()), false);
                break;
            }
            case REMOVE: {
                placer.getIterator().setRemoving();
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().m_8055_(pos).m_60734_() instanceof AirBlock || info.getBlockInfo().getState().m_60734_() instanceof AirBlock || !handler.getWorld().m_8055_(pos).m_60819_().m_76178_() || info.getBlockInfo().getState().m_60734_() == com.ldtteam.structurize.blocks.ModBlocks.blockSolidSubstitution.get() || info.getBlockInfo().getState().m_60734_() == com.ldtteam.structurize.blocks.ModBlocks.blockSubstitution.get() || info.getBlockInfo().getState().m_60734_() == com.ldtteam.structurize.blocks.ModBlocks.blockSubstitution.get() || handler.getWorld().m_8055_(pos).m_60734_() instanceof IBuilderUndestroyable), true);
                break;
            }
            default: {
                result = placer.executeStructureStep(this.world, null, progress, StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().decrement((info, pos, handler) -> handler.getWorld().m_8055_(pos).m_60734_() instanceof IBuilderUndestroyable || handler.getWorld().m_8055_(pos).m_60734_() == Blocks.f_50752_ || handler.getWorld().m_8055_(pos).m_60734_() instanceof AirBlock || info.getBlockInfo().getState().m_60734_() == com.ldtteam.structurize.blocks.ModBlocks.blockFluidSubstitution.get() || !handler.getWorld().m_8055_(pos).m_60819_().m_76178_()), false);
                if (result.getBlockResult().getResult() != BlockPlacementResult.Result.FINISHED) break;
                ((AbstractBuildingStructureBuilder)this.building).checkOrRequestBucket(((AbstractBuildingStructureBuilder)this.building).getRequiredResources(), this.worker.getCitizenData(), true);
            }
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FAIL) {
            Log.getLogger().error("Failed placement at: " + result.getBlockResult().getWorldPos().m_123344_());
        }
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.FINISHED) {
            ((AbstractBuildingStructureBuilder)this.building).nextStage();
            if (!this.structurePlacer.getB().nextStage()) {
                ((AbstractBuildingStructureBuilder)this.building).setProgressPos(null, null);
                return AIWorkerState.COMPLETE_BUILD;
            }
        } else if (result.getBlockResult().getResult() == BlockPlacementResult.Result.LIMIT_REACHED) {
            this.limitReached = true;
        }
        this.storeProgressPos(result.getIteratorPos(), this.structurePlacer.getB().getStage());
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.MISSING_ITEMS) {
            if (AbstractEntityAIStructure.hasListOfResInInvOrRequest(this, result.getBlockResult().getRequiredItems(), result.getBlockResult().getRequiredItems().size() > 1) == ItemCheckResult.RECALC) {
                ((AbstractJobStructure)this.job).getWorkOrder().setRequested(false);
                return AIWorkerState.LOAD_STRUCTURE;
            }
            return AIWorkerState.NEEDS_ITEM;
        }
        this.worker.m_6674_(InteractionHand.MAIN_HAND);
        this.worker.queueSound(SoundEvents.f_11718_, this.worker.m_20183_(), 10, 0, 0.5f, 0.1f);
        if (result.getBlockResult().getResult() == BlockPlacementResult.Result.BREAK_BLOCK) {
            this.blockToMine = result.getBlockResult().getWorldPos();
            return AIWorkerState.MINE_BLOCK;
        }
        this.blockToMine = null;
        if ((Integer)MineColonies.getConfig().getServer().builderBuildBlockDelay.get() > 0) {
            double decrease = 1.0 - this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_PLACE_SPEED);
            this.setDelay((int)((double)((Integer)MineColonies.getConfig().getServer().builderBuildBlockDelay.get() * 10 / (this.getPlaceSpeedLevel() / 2 + 10)) * decrease));
        }
        return this.getState();
    }

    public abstract int getPlaceSpeedLevel();

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.PICK_UP;
    }

    @Override
    public IAIState afterRequestPickUp() {
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PICK_UP;
    }

    public IAIState doMining() {
        if (this.blockToMine == null || this.world.m_8055_(this.blockToMine).m_60734_() instanceof AirBlock) {
            return AIWorkerState.BUILDING_STEP;
        }
        if (!this.mineBlock(this.blockToMine, this.getCurrentWorkingPosition())) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        return AIWorkerState.BUILDING_STEP;
    }

    public void loadStructure(@NotNull String packName, String blueprintPath, int rotateTimes, BlockPos position, boolean isMirrored, boolean removal) {
        Future blueprintFuture = StructurePacks.getBlueprintFuture((String)packName, (String)blueprintPath);
        this.loadingBlueprint = true;
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(blueprintFuture, this.world, blueprint -> {
            BuildingStructureHandler structure;
            if (blueprint == null) {
                this.handleSpecificCancelActions();
                Log.getLogger().warn("Couldn't find structure with name: " + blueprintPath + " in: " + packName + ". Aborting loading procedure");
                this.loadingBlueprint = false;
                return;
            }
            IBuilding colonyBuilding = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(position);
            BlockEntity entity = this.world.m_7702_(position);
            if (removal) {
                structure = new BuildingStructureHandler(this.world, position, (Blueprint)blueprint, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.REMOVE_WATER, BuildingStructureHandler.Stage.REMOVE});
                ((AbstractBuildingStructureBuilder)this.building).setTotalStages(2);
            } else if (colonyBuilding != null && (colonyBuilding.getBuildingLevel() > 0 || colonyBuilding.hasParent()) || entity instanceof TileEntityDecorationController && Utils.getBlueprintLevel(((TileEntityDecorationController)entity).getBlueprintPath()) != -1) {
                structure = new BuildingStructureHandler(this.world, position, (Blueprint)blueprint, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.BUILD_SOLID, BuildingStructureHandler.Stage.WEAK_SOLID, BuildingStructureHandler.Stage.CLEAR_WATER, BuildingStructureHandler.Stage.CLEAR_NON_SOLIDS, BuildingStructureHandler.Stage.DECORATE, BuildingStructureHandler.Stage.SPAWN});
                ((AbstractBuildingStructureBuilder)this.building).setTotalStages(5);
            } else {
                structure = new BuildingStructureHandler(this.world, position, (Blueprint)blueprint, new PlacementSettings(isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(rotateTimes)), this, new BuildingStructureHandler.Stage[]{BuildingStructureHandler.Stage.CLEAR, BuildingStructureHandler.Stage.BUILD_SOLID, BuildingStructureHandler.Stage.WEAK_SOLID, BuildingStructureHandler.Stage.CLEAR_WATER, BuildingStructureHandler.Stage.CLEAR_NON_SOLIDS, BuildingStructureHandler.Stage.DECORATE, BuildingStructureHandler.Stage.SPAWN});
                ((AbstractBuildingStructureBuilder)this.building).setTotalStages(6);
            }
            ((AbstractJobStructure)this.job).setBlueprint((Blueprint)blueprint);
            ((AbstractJobStructure)this.job).getBlueprint().rotateWithMirror(BlockPosUtil.getRotationFromRotations(rotateTimes), isMirrored ? Mirror.FRONT_BACK : Mirror.NONE, this.world);
            this.setStructurePlacer(structure);
            if (this.getProgressPos() != null) {
                structure.setStage(this.getProgressPos().getB());
            }
            this.loadingBlueprint = false;
        }));
    }

    public void setStructurePlacer(BuildingStructureHandler<J, B> structure) {
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<J, BuildingStructureHandler<J, B>>>(new StructurePlacer(structure), structure);
    }

    public static <J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder> ItemCheckResult hasListOfResInInvOrRequest(@NotNull AbstractEntityAIStructure<J, B> placer, List<ItemStack> itemList, boolean force) {
        HashMap<ItemStorage, Integer> requestedMap = new HashMap<ItemStorage, Integer>();
        for (ItemStack itemStack2 : itemList) {
            if (itemStack2.m_41720_() instanceof BlockItem && AbstractEntityAIStructure.isBlockFree(((BlockItem)itemStack2.m_41720_()).m_40614_().m_49966_())) continue;
            ItemStorage tempStorage = new ItemStorage(itemStack2.m_41777_());
            if (requestedMap.containsKey(tempStorage)) {
                int n = (Integer)requestedMap.get(tempStorage);
                tempStorage.setAmount(tempStorage.getAmount() + n);
            }
            requestedMap.put(tempStorage, tempStorage.getAmount());
        }
        for (ItemStorage itemStorage : requestedMap.keySet()) {
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)placer.getInventory(), stack1 -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStorage.getItemStack(), stack1)) || ((AbstractBuildingStructureBuilder)placer.building).hasResourceInBucket(itemStorage.getItemStack())) continue;
            return ItemCheckResult.RECALC;
        }
        List<ItemStack> foundStacks = InventoryUtils.filterItemHandler((IItemHandler)placer.getWorker().getInventoryCitizen(), itemStack -> requestedMap.keySet().stream().anyMatch(storage -> ItemStackUtils.compareItemStacksIgnoreStackSize(storage.getItemStack(), itemStack)));
        HashMap<ItemStorage, Integer> hashMap = new HashMap<ItemStorage, Integer>();
        for (ItemStack itemStack3 : foundStacks) {
            ItemStorage tempStorage = new ItemStorage(itemStack3.m_41777_());
            if (hashMap.containsKey(tempStorage)) {
                int oldSize = (Integer)hashMap.get(tempStorage);
                tempStorage.setAmount(tempStorage.getAmount() + oldSize);
            }
            hashMap.put(tempStorage, tempStorage.getAmount());
        }
        if (force) {
            for (Map.Entry entry2 : hashMap.entrySet()) {
                int req = requestedMap.getOrDefault(entry2.getKey(), 0);
                if (req == 0) continue;
                if ((Integer)entry2.getValue() >= req) {
                    requestedMap.remove(entry2.getKey());
                    continue;
                }
                requestedMap.put((ItemStorage)entry2.getKey(), req - (Integer)entry2.getValue());
            }
        } else {
            requestedMap.entrySet().removeIf(entry -> ItemStackUtils.isEmpty(((ItemStorage)entry.getKey()).getItemStack()) != false || foundStacks.stream().anyMatch(target -> ItemStackUtils.compareItemStacksIgnoreStackSize(target, ((ItemStorage)entry.getKey()).getItemStack())));
        }
        Iterator<Object> iterator = requestedMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry3 = (Map.Entry)iterator.next();
            ItemStack stack = ((ItemStorage)entry3.getKey()).getItemStack();
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                return ItemCheckResult.FAIL;
            }
            ImmutableList requests = ((AbstractBuildingStructureBuilder)placer.building).getOpenRequestsOfTypeFiltered(placer.getWorker().getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack));
            ImmutableList completedRequests = ((AbstractBuildingStructureBuilder)placer.building).getCompletedRequestsOfTypeFiltered(placer.getWorker().getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack));
            if (requests.isEmpty() && completedRequests.isEmpty()) {
                Stack stackRequest = new Stack(stack, placer.getTotalAmount(stack).m_41613_(), 1);
                placer.getWorker().getCitizenData().createRequest(stackRequest);
                placer.registerBlockAsNeeded(stack);
                return ItemCheckResult.FAIL;
            }
            for (IRequest request : requests) {
                if (!placer.worker.getCitizenJobHandler().getColonyJob().getAsyncRequests().contains(request.getId())) continue;
                placer.worker.getCitizenJobHandler().getColonyJob().markRequestSync((IToken<?>)request.getId());
            }
            for (IRequest request : completedRequests) {
                if (!placer.worker.getCitizenJobHandler().getColonyJob().getAsyncRequests().contains(request.getId())) continue;
                placer.worker.getCitizenJobHandler().getColonyJob().markRequestSync((IToken<?>)request.getId());
            }
            return ItemCheckResult.FAIL;
        }
        return ItemCheckResult.SUCCESS;
    }

    public IAIState loadRequirements() {
        return AIWorkerState.START_WORKING;
    }

    public boolean requestMaterials() {
        return true;
    }

    public void registerBlockAsNeeded(ItemStack stack) {
    }

    public void storeProgressPos(BlockPos blockPos, BuildingStructureHandler.Stage stage) {
    }

    @Override
    public void fillItemsList() {
        if (!this.structurePlacer.getB().hasBluePrint()) {
            return;
        }
        Blueprint blueprint = this.structurePlacer.getB().getBluePrint();
        BlockPos leftCorner = this.structurePlacer.getB().getWorldPos().m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
        this.searchForItems(new AABB(leftCorner, leftCorner.m_7918_((int)blueprint.getSizeX(), (int)blueprint.getSizeY(), (int)blueprint.getSizeZ())));
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        short length = this.structurePlacer.getB().getBluePrint().getSizeX();
        short width = this.structurePlacer.getB().getBluePrint().getSizeZ();
        int distance = Math.max(width, length) + 3;
        return this.getWorkingPosition(distance, targetPosition, 0);
    }

    public static boolean isBlockFree(@Nullable BlockState block) {
        return block == null || BlockUtils.isWater((BlockState)block) || block.m_204336_(BlockTags.f_13035_) || block.m_60734_() == ModBlocks.blockDecorationPlaceholder;
    }

    protected boolean isAlreadyCleared() {
        return false;
    }

    protected BlockPos getCurrentWorkingPosition() {
        return this.workFrom == null ? this.getWorkingPosition(this.structurePlacer.getB().getProgressPosInWorld(this.structurePlacer.getA().getIterator().getProgressPos())) : this.workFrom;
    }

    protected boolean isThereAStructureToBuild() {
        return this.structurePlacer != null && this.structurePlacer.getB().hasBluePrint();
    }

    public void reduceNeededResources(ItemStack stack) {
    }

    public void checkForExtraBuildingActions() {
    }

    public void handleSpecificCancelActions() {
    }

    @Nullable
    public ItemStack getTotalAmount(@Nullable ItemStack stack) {
        return stack;
    }

    public void resetCurrentStructure() {
        this.workFrom = null;
        this.structurePlacer = null;
        ((AbstractBuildingStructureBuilder)this.building).setProgressPos(null, null);
    }

    public AbstractEntityCitizen getWorker() {
        return this.worker;
    }

    public abstract Tuple<BlockPos, BuildingStructureHandler.Stage> getProgressPos();

    public abstract boolean shallReplaceSolidSubstitutionBlock(Block var1, BlockState var2);

    public BlockState getSolidSubstitution(BlockPos ignored) {
        return ((AbstractBuildingStructureBuilder)this.building).getSetting(BuildingMiner.FILL_BLOCK).getValue().m_40614_().m_49966_();
    }

    protected abstract void executeSpecificCompleteActions();

    protected abstract boolean checkIfCanceled();

    public static enum ItemCheckResult {
        FAIL,
        SUCCESS,
        RECALC;

    }
}

