/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class CustomArrowEntity
extends Arrow {
    private static final int MAX_LIVE_TIME = 200;
    private boolean armorPiercePlayer = false;
    private Predicate<EntityHitResult> onHitCallback = null;

    public CustomArrowEntity(EntityType<? extends Arrow> type, Level world) {
        super(type, world);
    }

    protected void m_7761_(LivingEntity target) {
        super.m_7761_(target);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_5790_(EntityHitResult traceResult) {
        Entity player;
        double prevDamage = this.m_36789_();
        float f = (float)this.m_20184_().m_82553_();
        if (f != 0.0f) {
            this.m_36781_(prevDamage / (double)f);
        }
        if (this.armorPiercePlayer && (player = traceResult.m_82443_()) instanceof Player) {
            Entity shooter = this.m_19749_();
            DamageSource source = shooter == null ? this.f_19853_.m_269111_().m_269418_((AbstractArrow)this, (Entity)this) : this.f_19853_.m_269111_().m_269418_((AbstractArrow)this, shooter);
            this.setPlayerArmorPierce();
            player.m_6469_(source, (float)this.m_36789_());
            this.m_36781_(0.0);
        }
        super.m_5790_(traceResult);
        this.m_36781_(prevDamage);
        if (this.onHitCallback != null && this.onHitCallback.test(traceResult)) {
            this.onHitCallback = null;
        }
    }

    public void setOnHitCallback(Predicate<EntityHitResult> onHitCallback) {
        this.onHitCallback = onHitCallback;
    }

    public void setPlayerArmorPierce() {
        this.armorPiercePlayer = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

