/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.colony.crafting.ToolUsage;
import com.minecolonies.coremod.colony.crafting.ToolsAnalyzer;
import com.minecolonies.coremod.compatibility.jei.ModRecipeTypes;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ToolRecipeCategory
implements IRecipeCategory<ToolUsage> {
    private static final int WIDTH = 180;
    private static final int HEIGHT = 44;
    private static final int SLOT_X = 70;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;

    public ToolRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(180, 44);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModItems.plateArmorChest));
        this.slot = guiHelper.getSlotDrawable();
    }

    @NotNull
    public static List<ToolUsage> findRecipes() {
        return ToolsAnalyzer.findTools();
    }

    @NotNull
    public RecipeType<ToolUsage> getRecipeType() {
        return ModRecipeTypes.TOOLS;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"com.minecolonies.coremod.jei.tools");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull ToolUsage recipe, @NotNull IFocusGroup focuses) {
        int x = 70;
        int y = 8;
        for (int i = 0; i <= 5; ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y).setSlotName("L" + i).addItemStacks(recipe.toolLevels().get(i))).setBackground(this.slot, -1, -1);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, x, y + 18).setSlotName("L" + i + "e").addItemStacks(recipe.enchantedToolLevels().get(i))).setBackground(this.slot, -1, -1);
            x += 18;
        }
    }

    public void draw(@NotNull ToolUsage recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        List lines = mc.f_91062_.m_92865_().m_92414_((FormattedText)recipe.tool().getDisplayName(), 66, Style.f_131099_);
        int n = lines.size();
        Objects.requireNonNull(mc.f_91062_);
        int y = 44 - (36 + n * 9) / 2 - 1;
        for (int i = 0; i < lines.size(); ++i) {
            Font font = mc.f_91062_;
            FormattedCharSequence formattedCharSequence = Language.m_128107_().m_5536_((FormattedText)lines.get(i));
            Objects.requireNonNull(mc.f_91062_);
            stack.m_280649_(font, formattedCharSequence, 2, y + i * 9, 0, false);
        }
        int scale = 2;
        int x = 70;
        for (int i = 0; i <= 5; ++i) {
            MutableComponent text = Component.m_237110_((String)"com.minecolonies.coremod.jei.onelevelrestriction", (Object[])new Object[]{i});
            stack.m_280614_(mc.f_91062_, (Component)text, (x + (18 - mc.f_91062_.m_92852_((FormattedText)text) / 2) / 2) * 2, 2, 0, false);
            x += 18;
        }
    }
}

