/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.minecolonies.coremod.util.BackUpHelper;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandDeleteColony
implements IMCColonyOfficerCommand {
    private static final String DELETE_BUILDNGS_ARG = "delete Buildings?";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).m_6761_(4) && !((Boolean)MineColonies.getConfig().getServer().canPlayerUseDeleteColonyCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notenabledinconfig"), true);
            return 0;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        boolean deleteBuildings = BoolArgumentType.getBool(context, (String)DELETE_BUILDNGS_ARG);
        BackUpHelper.backupColonyData();
        IColonyManager.getInstance().deleteColonyByDimension(colonyID, deleteBuildings, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.delete.success", (Object[])new Object[]{colony.getName()}), true);
        return 1;
    }

    @Override
    public String getName() {
        return "delete";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        String[] s = new String[]{"true delete buildings", "false keep buildings"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument(DELETE_BUILDNGS_ARG, BoolArgumentType.bool()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82967_((String[])s, (SuggestionsBuilder)builder)).then(IMCCommand.newArgument("", StringArgumentType.string()).then(IMCCommand.newArgument("", StringArgumentType.string()).executes(this::checkPreConditionAndExecute)))));
    }
}

