/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJobStructure<AI extends AbstractAISkeleton<J>, J extends AbstractJobStructure<AI, J>>
extends AbstractJob<AI, J> {
    private static final String TAG_WORK_ORDER = "workorder";
    private int workOrderId;
    protected Blueprint blueprint;

    public AbstractJobStructure(ICitizenData entity) {
        super(entity);
    }

    public boolean hasBlueprint() {
        return this.blueprint != null;
    }

    public Blueprint getBlueprint() {
        return this.blueprint;
    }

    public void setBlueprint(Blueprint blueprint) {
        this.blueprint = blueprint;
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public boolean hasWorkOrder() {
        return this.workOrderId != 0;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.workOrderId != 0) {
            compound.m_128405_(TAG_WORK_ORDER, this.workOrderId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_(TAG_WORK_ORDER)) {
            this.workOrderId = compound.m_128451_(TAG_WORK_ORDER);
        }
    }

    public void complete() {
        this.getWorkOrder().onCompleted(this.getCitizen().getColony(), this.getCitizen());
        if (this.blueprint != null) {
            CompoundTag[][][] tileEntityData = this.blueprint.getTileEntities();
            for (short x = 0; x < this.blueprint.getSizeX(); x = (short)(x + 1)) {
                for (short y = 0; y < this.blueprint.getSizeY(); y = (short)(y + 1)) {
                    for (short z = 0; z < this.blueprint.getSizeZ(); z = (short)(z + 1)) {
                        CompoundTag compoundNBT = tileEntityData[y][z][x];
                        if (compoundNBT == null || !compoundNBT.m_128441_("blueprintDataProvider")) continue;
                        BlockPos tePos = this.getWorkOrder().getLocation().m_121996_((Vec3i)this.blueprint.getPrimaryBlockOffset()).m_7918_((int)x, (int)y, (int)z);
                        BlockEntity te = this.getColony().getWorld().m_7702_(tePos);
                        if (!(te instanceof IBlueprintDataProviderBE)) continue;
                        CompoundTag tagData = compoundNBT.m_128469_("blueprintDataProvider");
                        String schematicPath = tagData.m_128461_("name");
                        String location = StructurePacks.getStructurePack((String)this.blueprint.getPackName()).getSubPath(Utils.resolvePath(this.blueprint.getFilePath(), schematicPath));
                        tagData.m_128359_("name", location);
                        tagData.m_128359_("pack", this.blueprint.getPackName());
                        try {
                            ((IBlueprintDataProviderBE)te).readSchematicDataFromNBT(compoundNBT);
                        }
                        catch (Exception e) {
                            Log.getLogger().warn("Broken deco-controller at: " + x + " " + y + " " + z);
                        }
                        ((ServerLevel)this.getColony().getWorld()).m_7726_().m_8450_(tePos);
                        te.m_6596_();
                    }
                }
            }
        }
        this.getCitizen().getColony().getWorkManager().removeWorkOrder(this.workOrderId);
        this.setWorkOrder(null);
        this.setBlueprint(null);
    }

    public IWorkOrder getWorkOrder() {
        return this.getColony().getWorkManager().getWorkOrder(this.workOrderId, IWorkOrder.class);
    }

    private void resetNeededItems() {
        IBuilding workerBuilding = this.getCitizen().getWorkBuilding();
        if (workerBuilding instanceof AbstractBuildingStructureBuilder) {
            ((AbstractBuildingStructureBuilder)workerBuilding).resetNeededResources();
        }
    }

    public void setWorkOrder(@Nullable IWorkOrder order) {
        if (order == null) {
            this.workOrderId = 0;
            this.resetNeededItems();
        } else {
            this.workOrderId = order.getID();
        }
    }
}

