/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.fields.registry;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class FieldDataManager {
    private static final String TAG_FIELD_NAME = "name";
    private static final String TAG_FIELD_POSITION = "position";
    private static final String TAG_FIELD_DATA = "data";

    private FieldDataManager() {
    }

    public static IField compoundToField(@NotNull CompoundTag compound) {
        BlockPos position;
        ResourceLocation fieldName = new ResourceLocation(compound.m_128461_(TAG_FIELD_NAME));
        IField field = FieldDataManager.resourceLocationToField(fieldName, position = BlockPosUtil.read(compound, TAG_FIELD_POSITION));
        if (field != null) {
            field.deserializeNBT(compound.m_128469_(TAG_FIELD_DATA));
        }
        return field;
    }

    public static IField resourceLocationToField(@NotNull ResourceLocation fieldName, @NotNull BlockPos position) {
        FieldRegistries.FieldEntry fieldEntry = (FieldRegistries.FieldEntry)FieldRegistries.getFieldRegistry().getValue(fieldName);
        if (fieldEntry == null) {
            Log.getLogger().error("Unknown field type '{}'.", (Object)fieldName);
            return null;
        }
        return fieldEntry.produceField(position);
    }

    public static IField bufferToField(@NotNull FriendlyByteBuf buf) {
        FieldRegistries.FieldEntry fieldType = (FieldRegistries.FieldEntry)buf.readRegistryIdSafe(FieldRegistries.FieldEntry.class);
        BlockPos position = buf.m_130135_();
        IField field = fieldType.produceField(position);
        field.deserialize(buf);
        return field;
    }

    public static FriendlyByteBuf fieldToBuffer(@NotNull IField field) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeRegistryId(FieldRegistries.getFieldRegistry(), (Object)field.getFieldType());
        buf.m_130064_(field.getPosition());
        field.serialize(buf);
        return buf;
    }

    public static CompoundTag fieldToCompound(@NotNull IField field) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(TAG_FIELD_NAME, field.getFieldType().getRegistryName().toString());
        BlockPosUtil.write(compound, TAG_FIELD_POSITION, field.getPosition());
        compound.m_128365_(TAG_FIELD_DATA, (Tag)field.serializeNBT());
        return compound;
    }
}

