/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.crafting.ToolUsage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public final class ToolsAnalyzer {
    @NotNull
    public static List<ToolUsage> findTools() {
        HashMap<ToolType, ToolUsage> toolItems = new HashMap<ToolType, ToolUsage>();
        for (ItemStack stack : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
            for (ToolType tool : ToolType.values()) {
                if (tool == ToolType.NONE || !ItemStackUtils.isTool(stack, tool)) continue;
                ToolsAnalyzer.tryAddingToolWithLevel(toolItems, tool, stack);
                if (!stack.m_41792_()) continue;
                for (int enchantLevel = 1; enchantLevel < 4; ++enchantLevel) {
                    ToolsAnalyzer.tryAddingEnchantedTool(toolItems, tool, stack, enchantLevel);
                }
            }
        }
        return toolItems.values().stream().sorted(Comparator.comparing(ToolUsage::tool)).toList();
    }

    private static void tryAddingEnchantedTool(@NotNull Map<ToolType, ToolUsage> toolItems, @NotNull ToolType tool, @NotNull ItemStack stack, int enchantLevel) {
        ItemStack enchantedStack = stack.m_41777_();
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44986_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44982_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44990_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44987_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44965_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44954_, enchantLevel);
        ToolsAnalyzer.tryAddingToolWithLevel(toolItems, tool, enchantedStack);
    }

    private static void tryEnchantStack(@NotNull ItemStack stack, @NotNull Enchantment enchantment, int enchantLevel) {
        if (enchantment.m_6081_(stack) && enchantLevel >= enchantment.m_44702_() && enchantLevel <= enchantment.m_6586_()) {
            stack.m_41663_(enchantment, enchantLevel);
        }
    }

    private static void tryAddingToolWithLevel(@NotNull Map<ToolType, ToolUsage> toolItems, @NotNull ToolType tool, @NotNull ItemStack stack) {
        int level = ItemStackUtils.getMiningLevel(stack, tool);
        if (level < 0) {
            return;
        }
        level = Math.min(5, level + ItemStackUtils.getMaxEnchantmentLevel(stack));
        ToolUsage usage = toolItems.computeIfAbsent(tool, ToolUsage::create);
        if (stack.m_41793_()) {
            usage.enchantedToolLevels().get(level).add(stack);
        } else {
            usage.toolLevels().get(level).add(stack);
        }
    }
}

