/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BuildingSmeltery
extends AbstractBuilding {
    private static final String SMELTERY_DESC = "smeltery";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int STUFF_TO_KEEP = 10;

    public BuildingSmeltery(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(IColonyManager.getInstance().getCompatibilityManager()::isOre, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack) == false && (stack.m_41720_() instanceof SwordItem || stack.m_41720_() instanceof DiggerItem || stack.m_41720_() instanceof ArmorItem), new Tuple((Object)10, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SMELTERY_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public int ingotMultiplier(int skillLevel, Random random) {
        switch (this.getBuildingLevel()) {
            case 1: {
                return random.nextInt(100 - skillLevel / 2) == 0 ? 2 : 1;
            }
            case 2: {
                return random.nextInt(100 - skillLevel) == 0 ? 2 : 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return random.nextInt(100 - skillLevel / 2) == 0 ? 3 : 2;
            }
            case 5: {
                return random.nextInt(100 - skillLevel) == 0 ? 3 : 2;
            }
        }
        return 1;
    }

    public static class OreBreakingModule
    extends AbstractCraftingBuildingModule.Custom {
        public OreBreakingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public List<ResourceLocation> getAdditionalLootTables() {
            ArrayList<ResourceLocation> lootTables = new ArrayList<ResourceLocation>(super.getAdditionalLootTables());
            for (Item input : ForgeRegistries.ITEMS.tags().getTag(ModTags.breakable_ore)) {
                lootTables.add(this.getLootTable(input));
            }
            return lootTables;
        }

        @Override
        protected boolean isPreTaughtRecipe(IRecipeStorage storage, Map<ResourceLocation, CustomRecipe> crafterRecipes) {
            if (storage.getPrimaryOutput().m_41619_() && storage.getLootTable() != null) {
                return true;
            }
            return super.isPreTaughtRecipe(storage, crafterRecipes);
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            for (Item input : ForgeRegistries.ITEMS.tags().getTag(ModTags.breakable_ore)) {
                recipes.add(new GenericRecipe(null, ItemStack.f_41583_, Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack((ItemLike)input))), 1, Blocks.f_50016_, this.getLootTable(input), ToolType.PICKAXE, Collections.emptyList(), -1));
            }
            return recipes;
        }

        @Override
        public void checkForWorkerSpecificRecipes() {
            super.checkForWorkerSpecificRecipes();
            for (Item input : ForgeRegistries.ITEMS.tags().getTag(ModTags.breakable_ore)) {
                Block b = Block.m_49814_((Item)input);
                List drops = Block.m_49869_((BlockState)b.m_49966_(), (ServerLevel)((ServerLevel)this.building.getColony().getWorld()), (BlockPos)this.building.getID(), null);
                for (ItemStack drop : drops) {
                    if (drop.m_41619_()) continue;
                    drop.m_41764_(1);
                }
                RecipeStorage tempRecipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{Collections.singletonList(new ItemStorage(new ItemStack((ItemLike)input))), 1, ItemStack.f_41583_, null, null, null, null, drops, this.getLootTable(input)});
                IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(tempRecipe);
                this.addRecipeToList(token, false);
            }
        }

        @Override
        public ItemStack getCraftingTool(AbstractEntityCitizen worker) {
            ItemStack pick = new ItemStack((ItemLike)Items.f_42390_);
            int fortuneLevel = this.building.getBuildingLevel() - 1;
            if (fortuneLevel > 0) {
                pick.m_41663_(Enchantments.f_44987_, fortuneLevel);
            }
            return pick;
        }

        protected ResourceLocation getLootTable(Item item) {
            if (item instanceof BlockItem) {
                Block itemBlock = Block.m_49814_((Item)item);
                return itemBlock.m_60589_();
            }
            return null;
        }
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            ICompatibilityManager compatibility = IColonyManager.getInstance().getCompatibilityManager();
            for (ItemStack stack : compatibility.getListOfAllItems()) {
                if (!ItemStackUtils.IS_SMELTABLE.and(compatibility::isOre).and(s -> !s.m_204117_(ModTags.breakable_ore)).test(stack)) continue;
                ItemStack output = FurnaceRecipes.getInstance().getSmeltingResult(stack);
                recipes.add(SmeltingModule.createSmeltingRecipe(new ItemStorage(stack), output, Blocks.f_50094_));
            }
            return recipes;
        }

        private static IGenericRecipe createSmeltingRecipe(ItemStorage input, ItemStack output, Block intermediate) {
            return GenericRecipe.of(StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{Collections.singletonList(input), 1, output, intermediate}));
        }
    }
}

