/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules.settings;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.client.gui.WindowSelectRes;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSetting
implements ISetting {
    private BlockItem value;
    private BlockItem defaultValue;

    public BlockSetting(BlockItem init) {
        this.value = init;
        this.defaultValue = init;
    }

    public BlockSetting(BlockItem value, BlockItem def) {
        this.value = value;
        this.defaultValue = def;
    }

    public BlockItem getValue() {
        return this.value;
    }

    public BlockItem getDefault() {
        return this.defaultValue;
    }

    public void setValue(BlockItem value) {
        this.value = value;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        Loader.createFromXMLFile((ResourceLocation)new ResourceLocation("minecolonies:gui/layouthuts/layoutblocksetting.xml"), (View)((View)pane));
        ((Text)pane.findPaneOfTypeByID("id", Text.class)).setText(Component.m_237113_((String)key.getUniqueId().toString()));
        ((Text)pane.findPaneOfTypeByID("desc", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.coremod.setting." + key.getUniqueId().toString())));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> new WindowSelectRes(window, stack -> {
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) {
                return false;
            }
            Block block = ((BlockItem)item).m_40614_();
            BlockState state = block.m_49966_();
            if (block instanceof EntityBlock || block instanceof FallingBlock || state.m_204336_(BlockTags.f_13035_)) {
                return false;
            }
            return block.m_5940_(state, (BlockGetter)new SingleStateBlockGetter(state), BlockPos.f_121853_, CollisionContext.m_82749_()).equals(Shapes.m_83144_()) && state.m_280555_();
        }, (stack, qty) -> {
            if (stack.m_41619_()) {
                return;
            }
            this.value = (BlockItem)stack.m_41720_();
            settingsModuleView.getSetting(new SettingKey(key.getType(), key.getUniqueId())).updateSetting(this);
            settingsModuleView.trigger(key);
        }, false).open());
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ItemIcon)pane.findPaneOfTypeByID("icon", ItemIcon.class)).setItem(new ItemStack((ItemLike)this.value));
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.switch"));
    }

    @Override
    public void trigger() {
    }

    @Override
    public void copyValue(ISetting iSetting) {
        if (iSetting instanceof BlockSetting) {
            BlockSetting other = (BlockSetting)iSetting;
            this.setValue(other.getValue());
        }
    }

    public class SingleStateBlockGetter
    implements BlockGetter {
        private final BlockState state;

        public SingleStateBlockGetter(BlockState state) {
            this.state = state;
        }

        @Nullable
        public BlockEntity m_7702_(@NotNull BlockPos pos) {
            return null;
        }

        @NotNull
        public BlockState m_8055_(@NotNull BlockPos pos) {
            if (pos == BlockPos.f_121853_) {
                return this.state;
            }
            return Blocks.f_50016_.m_49966_();
        }

        @NotNull
        public FluidState m_6425_(@NotNull BlockPos pos) {
            return Fluids.f_76191_.m_76145_();
        }

        public int m_141928_() {
            return Integer.MAX_VALUE;
        }

        public int m_141937_() {
            return Integer.MIN_VALUE;
        }
    }
}

