/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityEnchanter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityEnchanterRenderer
implements BlockEntityRenderer<TileEntityColonyBuilding> {
    public static final Material TEXTURE_BOOK = new Material(TextureAtlas.f_118259_, new ResourceLocation("minecolonies", "block/enchanting_table_book"));
    private final BookModel modelBook;

    public TileEntityEnchanterRenderer(BlockEntityRendererProvider.Context context) {
        this.modelBook = new BookModel(context.m_173582_(ModelLayers.f_171271_));
    }

    public void render(@NotNull TileEntityColonyBuilding ent, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource renderTypeBuffer, int lightA, int lightB) {
        if (ent instanceof TileEntityEnchanter) {
            TileEntityEnchanter entity = (TileEntityEnchanter)ent;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.75, 0.5);
            float tick = (float)entity.tickCount + partialTicks;
            matrixStack.m_85837_(0.0, (double)(0.1f + Mth.m_14031_((float)(tick * 0.1f)) * 0.01f), 0.0);
            double rotVPrev = entity.bookRotation - entity.bookRotationPrev;
            float circleRot = (float)(rotVPrev + Math.PI - Math.PI);
            float tickBasedRot = entity.bookRotationPrev + circleRot * partialTicks;
            matrixStack.m_252781_(Axis.f_252436_.m_252961_(-tickBasedRot));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(80.0f));
            float pageFlip = Mth.m_14179_((float)partialTicks, (float)entity.pageFlipPrev, (float)entity.pageFlip);
            float flipA = Mth.m_14187_((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
            float flipB = Mth.m_14187_((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
            float bookSpread = Mth.m_14179_((float)partialTicks, (float)entity.bookSpreadPrev, (float)entity.bookSpread);
            this.modelBook.m_102292_(tick, Mth.m_14036_((float)flipA, (float)0.0f, (float)1.0f), Mth.m_14036_((float)flipB, (float)0.0f, (float)1.0f), bookSpread);
            VertexConsumer vertexConsumer = TEXTURE_BOOK.m_119194_(renderTypeBuffer, RenderType::m_110446_);
            this.modelBook.m_7695_(matrixStack, vertexConsumer, lightA, lightB, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }
}

