/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.map.WindowColonyMap;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallMercenary;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallNameEntry;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.commands.ClickEventWithExecutable;
import com.minecolonies.coremod.network.messages.server.colony.TeleportToColonyMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowMainPage
extends AbstractWindowTownHall {
    private final ScrollingList alliesList = (ScrollingList)this.findPaneOfTypeByID("allies", ScrollingList.class);
    private final Text title;
    private final ScrollingList feudsList = (ScrollingList)this.findPaneOfTypeByID("feuds", ScrollingList.class);

    public WindowMainPage(BuildingTownHall.View building) {
        super(building, "layoutactions.xml");
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.registerButton("changeSpec", this::doNothing);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("mercenaries", this::mercenaryClicked);
        this.registerButton("map", this::mapButtonClicked);
        this.registerButton("patreon", this::patreonClicked);
        this.registerButton("tp", this::teleportToColony);
    }

    private void patreonClicked() {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(check -> {
            if (check) {
                Util.m_137581_().m_137646_("https://www.patreon.com/Minecolonies");
            }
            Minecraft.m_91087_().m_91152_((Screen)this.screen);
        }, "https://www.patreon.com/Minecolonies", true));
    }

    private void teleportToColony(@NotNull Button button) {
        int row = this.alliesList.getListElementIndexByPane((Pane)button);
        CompactColonyReference ally = ((ITownHallView)this.building).getColony().getAllies().get(row);
        MessageUtils.format("com.minecolonies.coremod.gui.townhall.tp", ally.name).with(Style.f_131099_.m_131142_((ClickEvent)new ClickEventWithExecutable(ClickEvent.Action.RUN_COMMAND, "", () -> Network.getNetwork().sendToServer(new TeleportToColonyMessage(ally.dimension, ally.id))))).with(ChatFormatting.BOLD, ChatFormatting.GOLD).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
        this.close();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fillAlliesAndFeudsList();
        this.title.setText(Component.m_237113_((String)((ITownHallView)this.building).getColony().getName()));
        if (((ITownHallView)this.building).getColony().getMercenaryUseTime() != 0L && ((ITownHallView)this.building).getColony().getWorld().m_46467_() - ((ITownHallView)this.building).getColony().getMercenaryUseTime() < 48000L) {
            ((Button)this.findPaneOfTypeByID("mercenaries", Button.class)).disable();
        }
    }

    private void fillAlliesAndFeudsList() {
        this.alliesList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowMainPage.this.building).getColony().getAllies().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowMainPage.this.building).getColony().getAllies().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)colonyReference.name));
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowMainPage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText(Component.m_237113_((String)((int)distance + "b")));
                Button button = (Button)rowPane.findPaneOfTypeByID("tp", Button.class);
                if (colonyReference.hasTownHall && (((ITownHallView)WindowMainPage.this.building).getBuildingLevel() < (Integer)MineColonies.getConfig().getServer().minThLevelToTeleport.get() || !((ITownHallView)WindowMainPage.this.building).canPlayerUseTP())) {
                    button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.townhall.toolow"));
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
        this.feudsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowMainPage.this.building).getColony().getFeuds().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowMainPage.this.building).getColony().getFeuds().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)colonyReference.name));
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowMainPage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText(Component.m_237113_((String)String.valueOf((int)distance)));
            }
        });
    }

    private void renameClicked() {
        @NotNull WindowTownHallNameEntry window = new WindowTownHallNameEntry(((ITownHallView)this.building).getColony());
        window.open();
    }

    private void mercenaryClicked() {
        @NotNull WindowTownHallMercenary window = new WindowTownHallMercenary(((ITownHallView)this.building).getColony());
        window.open();
    }

    private void mapButtonClicked() {
        @NotNull WindowColonyMap window = new WindowColonyMap(this.building);
        window.open();
    }

    @Override
    protected String getWindowId() {
        return "actions";
    }
}

