/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IItemListModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.ItemListModuleView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemListModuleWindow
extends AbstractModuleWindow {
    private final ScrollingList resourceList;
    protected final IBuildingView building;
    private String filter = "";
    private final boolean isInverted;
    private List<ItemStorage> groupedItemList;
    private final List<ItemStorage> currentDisplayedList = new ArrayList<ItemStorage>();
    private int tick;

    public ItemListModuleWindow(String res, IBuildingView building, IItemListModuleView moduleView) {
        super(building, res);
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        ((Text)this.window.findPaneOfTypeByID("desc", Text.class)).setText(Component.m_237115_((String)moduleView.getDesc().toLowerCase(Locale.US)));
        this.building = building;
        this.isInverted = moduleView.isInverted();
        this.id = moduleView.getId();
        this.groupedItemList = new ArrayList<ItemStorage>((Collection)moduleView.getAllItems().apply(building));
        ((TextField)this.window.findPaneOfTypeByID("input", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (Objects.equals(button.getID(), "switch")) {
            this.switchClicked(button);
        } else if (Objects.equals(button.getID(), "resetDefault")) {
            this.reset();
        }
    }

    public void onOpened() {
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private void switchClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ItemStorage item = this.currentDisplayedList.get(row);
        boolean on = button.getText().equals((Object)Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon"));
        boolean add = on && this.isInverted || !on && !this.isInverted;
        IItemListModuleView module = this.building.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(this.id));
        if (add) {
            module.addItem(item);
        } else {
            module.removeItem(item);
        }
        this.resourceList.refreshElementPanes();
    }

    private void reset() {
        IItemListModuleView module = this.building.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(this.id));
        module.clearItems();
        this.resourceList.refreshElementPanes();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.m_41778_().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.m_41786_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.currentDisplayedList.clear();
        for (ItemStorage storage : this.groupedItemList) {
            if (!filterPredicate.test(storage.getItemStack())) continue;
            this.currentDisplayedList.add(storage);
        }
        this.currentDisplayedList.sort((o1, o2) -> {
            boolean o1Allowed = this.building.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(this.id)).isAllowedItem((ItemStorage)o1);
            boolean o2Allowed = this.building.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(this.id)).isAllowedItem((ItemStorage)o2);
            if (!o1Allowed && o2Allowed) {
                return this.isInverted ? -1 : 1;
            }
            if (o1Allowed && !o2Allowed) {
                return this.isInverted ? 1 : -1;
            }
            return 0;
        });
        this.updateResourceList();
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ItemListModuleWindow.this.currentDisplayedList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ItemListModuleWindow.this.currentDisplayedList.get(index).getItemStack();
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.m_41786_());
                resourceLabel.setColors(7);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
                boolean isAllowedItem = ItemListModuleWindow.this.building.getModuleViewMatching(ItemListModuleView.class, view -> view.getId().equals(ItemListModuleWindow.this.id)).isAllowedItem(new ItemStorage(resource));
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                if (ItemListModuleWindow.this.isInverted && !isAllowedItem || !ItemListModuleWindow.this.isInverted && isAllowedItem) {
                    switchButton.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon"));
                } else {
                    switchButton.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
                }
            }
        });
    }
}

