/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.client.gui.AbstractModuleWindow;
import com.minecolonies.coremod.colony.buildings.moduleviews.FieldsModuleView;
import com.minecolonies.coremod.colony.fields.FarmField;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class FarmFieldsModuleWindow
extends AbstractModuleWindow {
    private static final String HUT_FIELDS_RESOURCE_SUFFIX = ":gui/layouthuts/layoutfarmfields.xml";
    private static final String LIST_FIELDS = "fields";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private static final String TAG_BUTTON_ASSIGN = "assignFarm";
    private static final String TAG_BUTTON_ASSIGNMENT_MODE = "assignmentMode";
    private static final String TAG_FIELD_COUNT = "fieldCount";
    private static final String RED_X = "X";
    private static final String APPROVE = "\u2713";
    private static final String TAG_ICON = "icon";
    private final FieldsModuleView moduleView;
    private ScrollingList fieldList;

    public FarmFieldsModuleWindow(IBuildingView building, FieldsModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutfarmfields.xml");
        this.moduleView = moduleView;
        this.registerButton(TAG_BUTTON_ASSIGNMENT_MODE, this::assignmentModeClicked);
        this.registerButton(TAG_BUTTON_ASSIGN, this::assignClicked);
    }

    private void assignmentModeClicked(@NotNull Button button) {
        this.moduleView.setAssignFieldManually(!this.moduleView.assignFieldManually());
        this.updateUI();
    }

    private void assignClicked(@NotNull Button button) {
        int row = this.fieldList.getListElementIndexByPane((Pane)button);
        IField field = this.moduleView.getFields().get(row);
        if (field.isTaken()) {
            this.moduleView.freeField(field);
        } else {
            this.moduleView.assignField(field);
        }
        this.updateUI();
    }

    private void updateUI() {
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_ASSIGNMENT_MODE, Button.class)).setText(Component.m_237115_((String)(this.moduleView.assignFieldManually() ? "com.minecolonies.coremod.gui.hiring.on" : "com.minecolonies.coremod.gui.hiring.off")));
        ((Text)this.findPaneOfTypeByID(TAG_FIELD_COUNT, Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.workerhuts.fields.fieldcount", (Object[])new Object[]{this.moduleView.getOwnedFields().size(), this.moduleView.getMaxFieldCount()}));
    }

    public void onOpened() {
        super.onOpened();
        this.fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_FIELDS, ScrollingList.class);
        this.fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return FarmFieldsModuleWindow.this.moduleView.getFields().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                FarmField farmField;
                IField field = FarmFieldsModuleWindow.this.moduleView.getFields().get(index);
                String distance = Integer.toString(field.getSqDistance(FarmFieldsModuleWindow.this.buildingView));
                Component direction = BlockPosUtil.calcDirection(FarmFieldsModuleWindow.this.buildingView.getPosition(), field.getPosition());
                ((Text)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_DISTANCE, Text.class)).setText(Component.m_237115_((String)(distance + "m")));
                ((Text)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_DIRECTION, Text.class)).setText(direction);
                Button assignButton = (Button)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_BUTTON_ASSIGN, Button.class);
                assignButton.setEnabled(FarmFieldsModuleWindow.this.moduleView.assignFieldManually());
                assignButton.setHoverPane(null);
                assignButton.show();
                if (field.isTaken() && !FarmFieldsModuleWindow.this.buildingView.getID().equals((Object)field.getBuildingId())) {
                    assignButton.hide();
                } else if (field.isTaken()) {
                    assignButton.setText(Component.m_237115_((String)FarmFieldsModuleWindow.RED_X).m_130940_(ChatFormatting.RED));
                } else {
                    assignButton.setText(Component.m_237115_((String)FarmFieldsModuleWindow.APPROVE).m_130940_(ChatFormatting.GREEN));
                    if (!FarmFieldsModuleWindow.this.moduleView.canAssignField(field)) {
                        assignButton.disable();
                        MutableComponent warningTooltip = FarmFieldsModuleWindow.this.moduleView.getFieldWarningTooltip(field);
                        if (warningTooltip != null && FarmFieldsModuleWindow.this.moduleView.assignFieldManually()) {
                            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(warningTooltip.m_130940_(ChatFormatting.RED))).hoverPane((Pane)assignButton).build();
                        }
                    }
                }
                if (field instanceof FarmField && !(farmField = (FarmField)field).getSeed().m_41619_()) {
                    ((ItemIcon)rowPane.findPaneOfTypeByID(FarmFieldsModuleWindow.TAG_ICON, ItemIcon.class)).setItem(farmField.getSeed());
                }
            }
        });
        this.updateUI();
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateUI();
    }
}

