/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.map;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.ldtteam.blockui.views.ZoomDragView;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.client.render.modeltype.ISimpleModelType;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.map.ColonySize;
import com.minecolonies.coremod.client.gui.map.MinecraftMap;
import com.minecolonies.coremod.client.gui.map.ZoomDragMap;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.colony.ColonyListMessage;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class WindowColonyMap
extends AbstractWindowSkeleton {
    private static final String WINDOW_RESOURCE = ":gui/map/windowcolonymap.xml";
    private static final double COLONY_DETAIL_SCALE = 0.3;
    private static List<ColonyListMessage.ColonyInfo> colonies = new ArrayList<ColonyListMessage.ColonyInfo>();
    private final BlockPos playerPos;
    private final ZoomDragMap dragView;
    private Map<ICitizenDataView, Pane> citizens = new HashMap<ICitizenDataView, Pane>();
    private Map<IBuildingView, ItemIcon> buildings = new HashMap<IBuildingView, ItemIcon>();
    private Map<ColonyListMessage.ColonyInfo, View> coloniesImages = new HashMap<ColonyListMessage.ColonyInfo, View>();
    private List<MinecraftMap> maps = new ArrayList<MinecraftMap>();
    private IBuildingView building;
    private final DecimalFormat scaleformet = new DecimalFormat("##");
    private double currentScale = 0.0;
    private boolean hasMaps = false;

    public WindowColonyMap(IBuildingView building) {
        super("minecolonies:gui/map/windowcolonymap.xml");
        this.building = building;
        this.playerPos = new BlockPos(Minecraft.m_91087_().f_91074_.m_20183_().m_123341_(), 0, Minecraft.m_91087_().f_91074_.m_20183_().m_123343_());
        ZoomDragView parent = (ZoomDragView)this.findPaneOfTypeByID("dragView", ZoomDragView.class);
        this.dragView = new ZoomDragMap();
        this.dragView.setSize(parent.getWidth(), parent.getHeight());
        this.dragView.setPosition(parent.getX(), parent.getY());
        this.dragView.enable();
        this.dragView.setVisible(true);
        this.dragView.setFocus();
        this.dragView.setWindow(this);
        parent.addChild((Pane)this.dragView);
        if (this.addMaps()) {
            this.addCitizens(building.getColony());
            this.addCenterPos();
        }
        this.registerButton("exit", () -> building.openGui(false));
        this.registerButton("inventory", this::inventoryClicked);
        Network.getNetwork().sendToServer(new ColonyListMessage());
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage(this.building));
    }

    private boolean addMaps() {
        for (MinecraftMap map : this.maps) {
            this.dragView.removeChild(map);
            map.close();
        }
        this.maps.clear();
        for (MapItemSavedData mapData : ((BuildingTownHall.View)this.building).getMapDataList()) {
            if (mapData.f_77890_ != 0) continue;
            this.hasMaps = true;
            MinecraftMap mapImage = new MinecraftMap();
            mapImage.setPosition(this.worldPosToUIPos(new BlockPos(mapData.f_256718_ - 64, 0, 0)).m_123341_(), this.worldPosToUIPos(new BlockPos(0, 0, mapData.f_256789_ - 64)).m_123343_());
            mapImage.setID("map" + mapData.f_256718_ + "-" + mapData.f_256789_);
            mapImage.setMapData(mapData);
            mapImage.setSize((int)(512.0 * this.currentScale), (int)(512.0 * this.currentScale));
            this.dragView.addChildFirst(mapImage);
            this.maps.add(mapImage);
        }
        this.findPaneByID("warning").setVisible(!this.hasMaps);
        return this.hasMaps;
    }

    public static void setColonies(List<ColonyListMessage.ColonyInfo> colonyInfo) {
        colonies = colonyInfo;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.hasMaps) {
            for (Map.Entry<ICitizenDataView, Pane> entry : this.citizens.entrySet()) {
                EntityCitizen citizen = (EntityCitizen)this.building.getColony().getWorld().m_6815_(entry.getKey().getEntityId());
                if (citizen == null) continue;
                entry.getValue().setPosition(this.worldPosToUIPos(citizen.m_20183_()).m_123341_(), this.worldPosToUIPos(citizen.m_20183_()).m_123343_());
            }
            if (this.currentScale != this.dragView.getScale()) {
                this.currentScale = this.dragView.getScale();
                this.updateScale();
            }
        }
    }

    private void updateScale() {
        for (ColonyListMessage.ColonyInfo colonyInfo : colonies) {
            this.updateColonyInfoImage(colonyInfo);
        }
        for (ColonyListMessage.ColonyInfo colonyInfo : colonies) {
            this.updateColonyInfoImage(colonyInfo);
        }
        for (IBuildingView iBuildingView : this.building.getColony().getBuildings()) {
            this.updateBuildingView(iBuildingView);
        }
        if (this.currentScale < 0.3) {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((ItemIcon)entry.getValue()).off();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((Pane)entry.getValue()).off();
            }
        } else {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((ItemIcon)entry.getValue()).on();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((Pane)entry.getValue()).on();
            }
            for (Map.Entry entry : this.coloniesImages.entrySet()) {
                ((View)entry.getValue()).off();
            }
        }
        this.addMaps();
        ((Text)this.findPaneOfTypeByID("scale", Text.class)).setText(Component.m_237113_((String)(this.scaleformet.format(1.0 / this.currentScale) + "x")));
    }

    private void updateColonyInfoImage(ColonyListMessage.ColonyInfo colonyInfo) {
        View colonyPane = this.coloniesImages.get(colonyInfo);
        if (colonyPane == null) {
            colonyPane = ColonySize.createViewForInfo(colonyInfo);
            colonyPane.setID(colonyInfo.getId() + colonyInfo.getOwner());
            this.dragView.addChild((Pane)colonyPane);
            this.coloniesImages.put(colonyInfo, colonyPane);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)colonyPane).append(Component.m_237113_((String)("Owner:" + colonyInfo.getOwner())))).appendNL(Component.m_237113_((String)("Coordinates: " + colonyInfo.getCenter().m_123341_() + "X, " + colonyInfo.getCenter().m_123343_() + "Z")))).appendNL(Component.m_237113_((String)("Citizens: " + colonyInfo.getCitizencount())))).build();
        }
        if (this.currentScale < 0.3) {
            colonyPane.setPosition(this.worldPosToUIPos(colonyInfo.getCenter()).m_123341_() - colonyPane.getWidth() / 2, this.worldPosToUIPos(colonyInfo.getCenter()).m_123343_() - colonyPane.getHeight() / 2);
            colonyPane.on();
        } else {
            colonyPane.off();
        }
    }

    private void addCenterPos() {
        Image citizenImage = new Image();
        citizenImage.setImage(new ResourceLocation("minecolonies", "textures/gui/red_wax_actions.png"), false);
        citizenImage.setSize(16, 16);
        citizenImage.setPosition(this.worldPosToUIPos(this.playerPos).m_123341_(), this.worldPosToUIPos(this.playerPos).m_123343_());
        this.dragView.addChild((Pane)citizenImage);
    }

    private void updateBuildingView(IBuildingView buildingView) {
        ItemIcon uiBuilding = this.buildings.get(buildingView);
        if (uiBuilding == null) {
            uiBuilding = new ItemIcon();
            uiBuilding.setID(buildingView.getID().m_123344_());
            uiBuilding.setSize(11 + buildingView.getBuildingLevel(), 11 + buildingView.getBuildingLevel());
            ItemStack item = buildingView.getBuildingType().getBuildingBlock().m_5456_().m_7968_();
            uiBuilding.setItem(item);
            this.dragView.addChild((Pane)uiBuilding);
            AbstractTextBuilder.TooltipBuilder tooltip = PaneBuilders.tooltipBuilder();
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)tooltip.hoverPane((Pane)uiBuilding).append((Component)BOScreen.m_280152_((Minecraft)this.mc, (ItemStack)item).get(0))).append(Component.m_237113_((String)(" : " + buildingView.getBuildingLevel())))).appendNL(Component.m_237113_((String)("Coordinates: " + buildingView.getID().m_123341_() + "X, " + buildingView.getID().m_123343_() + "Z")))).appendNL(Component.m_237113_((String)("Citizens: " + buildingView.getAllAssignedCitizens().size())));
            for (int id : buildingView.getAllAssignedCitizens()) {
                ICitizenDataView dataView = this.building.getColony().getCitizen(id);
                if (dataView == null) continue;
                tooltip.appendNL(Component.m_237113_((String)dataView.getName()));
            }
            tooltip.build();
            uiBuilding.setVisible(true);
            this.dragView.removeChild((Pane)this.buildings.get(buildingView));
            this.buildings.put(buildingView, uiBuilding);
        }
        uiBuilding.setPosition(this.worldPosToUIPos(buildingView.getID()).m_123341_(), this.worldPosToUIPos(buildingView.getID()).m_123343_());
    }

    private void addCitizens(IColonyView colony) {
        for (ICitizenDataView data : colony.getCitizens().values()) {
            EntityCitizen citizen = (EntityCitizen)colony.getWorld().m_6815_(data.getEntityId());
            if (citizen == null) continue;
            View citizenView = new View();
            citizenView.setPosition(this.worldPosToUIPos(citizen.m_20183_()).m_123341_(), this.worldPosToUIPos(citizen.m_20183_()).m_123343_());
            Image citizenImage = new Image();
            citizenImage.setImage(((ISimpleModelType)IModelTypeRegistry.getInstance().getModelType(citizen.getModelType())).getTextureIcon(citizen), false);
            citizenImage.setSize(4, 4);
            citizenView.addChild((Pane)citizenImage);
            this.dragView.addChild((Pane)citizenView);
            AbstractTextBuilder.TooltipBuilder builder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)citizenView).paragraphBreak()).append(citizen.m_5446_());
            if (!data.getJob().isEmpty()) {
                citizenImage.setSize(8, 8);
                ((AbstractTextBuilder.TooltipBuilder)builder.newLine()).append(Component.m_237110_((String)"com.minecolonies.coremod.gui.citizen.job.label", (Object[])new Object[]{LanguageHandler.format((String)data.getJob(), (Object[])new Object[0])}));
            }
            ((AbstractTextBuilder.TooltipBuilder)builder.color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            citizenView.setSize(citizenImage.getWidth(), citizenImage.getHeight());
            if (data.hasVisibleInteractions()) {
                Image interactionImage = new Image();
                interactionImage.setImage(data.getInteractionIcon(), false);
                interactionImage.setSize(6, 6);
                citizenImage.setPosition(5, 0);
                citizenView.addChild((Pane)interactionImage);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
            }
            this.dragView.removeChild(this.citizens.get(data));
            this.citizens.put(data, (Pane)citizenView);
        }
    }

    private BlockPos worldPosToUIPos(BlockPos worldPos) {
        return BlockPos.m_274561_((double)((double)this.dragView.getWidth() / 2.0 - (double)((this.playerPos.m_123341_() - worldPos.m_123341_()) * 4) / Math.max(1.0, Math.log((float)Math.abs(this.playerPos.m_123341_() - worldPos.m_123341_()) / 1000.0f)) * this.currentScale), (double)0.0, (double)((double)this.dragView.getHeight() / 2.0 - (double)((this.playerPos.m_123343_() - worldPos.m_123343_()) * 4) / Math.max(1.0, Math.log((float)Math.abs(this.playerPos.m_123343_() - worldPos.m_123343_()) / 1000.0f)) * this.currentScale));
    }

    public void onClosed() {
        super.onClosed();
        this.maps.forEach(MinecraftMap::close);
    }
}

