/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.ITickedWorldOperation;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.TickedWorldOperation;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.Utils;
import java.util.List;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreativeBuildingStructureHandler
extends CreativeStructureHandler {
    private IBuilding building;

    public CreativeBuildingStructureHandler(Level world, BlockPos pos, Blueprint blueprint, PlacementSettings settings, boolean fancyPlacement) {
        super(world, pos, blueprint, settings, fancyPlacement);
        this.setupBuilding();
    }

    public CreativeBuildingStructureHandler(Level world, BlockPos pos, Future<Blueprint> blueprint, PlacementSettings settings, boolean fancyPlacement) {
        super(world, pos, blueprint, settings, fancyPlacement);
        this.setupBuilding();
    }

    private void setupBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getWorld(), this.getWorldPos());
        if (colony != null) {
            this.building = colony.getBuildingManager().getBuilding(this.getWorldPos());
        }
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        BlockEntity te;
        super.triggerSuccess(pos, list, placement);
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        Blueprint blueprint = this.getBluePrint();
        CompoundTag teData = blueprint.getTileEntityData(worldPos, pos);
        if (teData != null && teData.m_128441_("blueprintDataProvider") && (te = this.getWorld().m_7702_(worldPos)) != null) {
            CompoundTag tagData = teData.m_128469_("blueprintDataProvider");
            String schematicPath = tagData.m_128461_("name");
            String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(Utils.resolvePath(blueprint.getFilePath(), schematicPath));
            tagData.m_128359_("name", location);
            tagData.m_128359_("pack", blueprint.getPackName());
            ((IBlueprintDataProviderBE)te).readSchematicDataFromNBT(teData);
            ((ServerLevel)this.getWorld()).m_7726_().m_8450_(worldPos);
            te.m_6596_();
        }
        if (this.building != null) {
            this.building.registerBlockPosition(blueprint.getBlockState(pos), worldPos, this.getWorld());
        }
    }

    public boolean shouldBlocksBeConsideredEqual(BlockState state1, BlockState state2) {
        Block block1 = state1.m_60734_();
        Block block2 = state2.m_60734_();
        if (block1 == Blocks.f_50276_ || block2 == Blocks.f_50276_) {
            return block1 == block2;
        }
        if (block1 == Blocks.f_50440_ && block2 == Blocks.f_50493_ || block2 == Blocks.f_50440_ && block1 == Blocks.f_50493_) {
            return true;
        }
        return super.shouldBlocksBeConsideredEqual(state1, state2);
    }

    public boolean isStackFree(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.m_41619_() || itemStack.m_204117_(ItemTags.f_13143_) || itemStack.m_41720_() == new ItemStack(ModBlocks.blockDecorationPlaceholder, 1).m_41720_();
    }

    public static Blueprint loadAndPlaceStructureWithRotation(Level worldObj, @NotNull Future<Blueprint> future, @NotNull BlockPos pos, Rotation rotation, @NotNull Mirror mirror, boolean fancyPlacement, @Nullable ServerPlayer player) {
        try {
            @NotNull CreativeBuildingStructureHandler structure = new CreativeBuildingStructureHandler(worldObj, pos, future, new PlacementSettings(mirror, rotation), fancyPlacement);
            if (structure.hasBluePrint()) {
                @NotNull StructurePlacer instantPlacer = new StructurePlacer((IStructureHandler)structure);
                Manager.addToQueue((ITickedWorldOperation)new TickedWorldOperation(instantPlacer, (Player)player));
            }
            return structure.getBluePrint();
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return null;
        }
    }
}

