/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class BlockStateUtils {
    private static final Map<String, Property<?>> propertyBlockMap = new HashMap();

    private BlockStateUtils() {
    }

    public static boolean stateEqualsStateByBlockAndProp(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull String propertyName) {
        if (state1.m_60734_() != state2.m_60734_()) {
            return false;
        }
        if (BlockStateUtils.stateEqualsStateInPropertyByName(state1, state2, propertyName)) {
            return true;
        }
        return state1 == state2;
    }

    public static boolean stateEqualsStateInPropertyByName(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull String propertyName) {
        Property<?> propertyOne = BlockStateUtils.getPropertyByNameFromState(state1, propertyName);
        if (propertyOne != null && state2.m_61138_(propertyOne)) {
            return state1.m_61143_(propertyOne) == state2.m_61143_(propertyOne);
        }
        Property<?> propertyTwo = BlockStateUtils.getPropertyByNameFromState(state2, propertyName);
        if (propertyOne != null && propertyTwo != null && state1.m_61138_(propertyOne) && state2.m_61138_(propertyTwo)) {
            return state1.m_61143_(propertyOne).toString().equals(state2.m_61143_(propertyTwo).toString());
        }
        return false;
    }

    public static Property<?> getPropertyByNameFromState(@NotNull BlockState state, @NotNull String name) {
        Property<?> property = propertyBlockMap.get(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString() + ":" + name);
        if (property != null && state.m_61138_(property)) {
            return property;
        }
        property = BlockStateUtils.getPropertyByName(state.m_61147_(), name);
        if (property != null) {
            propertyBlockMap.put(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).toString() + ":" + name, property);
        }
        return property;
    }

    public static Property<?> getPropertyByName(@NotNull Collection<Property<?>> properties, @NotNull String name) {
        for (Property<?> tProperty : properties) {
            if (!tProperty.m_61708_().equals(name)) continue;
            return tProperty;
        }
        return null;
    }

    public static <T extends Comparable<T>> boolean stateEqualsStateWithoutProp(@NotNull BlockState state1, @NotNull BlockState state2, @NotNull Property<T> prop) {
        if (!state1.m_61138_(prop) || !state2.m_61138_(prop)) {
            return state1 == state2;
        }
        return state1.m_61124_(prop, state2.m_61143_(prop)) == state2;
    }

    public static boolean stateEqualsStateInBlockAndProp(BlockState state1, BlockState state2) {
        if (state1 == null || state2 == null) {
            return false;
        }
        if (state1.m_60734_() != state2.m_60734_()) {
            return false;
        }
        if (state1.m_61147_().size() != state2.m_61147_().size()) {
            return false;
        }
        for (Property prop : state1.m_61147_()) {
            if (!state2.m_61138_(prop)) {
                return false;
            }
            if (state1.m_61143_(prop) == state2.m_61143_(prop)) continue;
            return false;
        }
        return true;
    }
}

