/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.cctweaked;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.utils.ComputerControlState;
import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.PeripheralCreator;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControllable;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GenericPeripheral<T extends BlockEntity>
implements IDynamicPeripheral {
    private final PeripheralCreator<T> creator;
    private final T object;

    public GenericPeripheral(PeripheralCreator<T> creator, T object) {
        this.creator = creator;
        this.object = object;
    }

    @Nonnull
    public String[] getMethodNames() {
        return this.creator.getMethodNames();
    }

    @Nonnull
    public MethodResult callMethod(@Nonnull IComputerAccess computerAccess, @Nonnull ILuaContext ctx, int index, @Nonnull IArguments luaArgs) throws LuaException {
        return this.creator.call(computerAccess, ctx, index, luaArgs, this.object);
    }

    @Nonnull
    public String getType() {
        return this.creator.getName();
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        GenericPeripheral otherGeneric = (GenericPeripheral)other;
        return this.creator == otherGeneric.creator && this.object == otherGeneric.object;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.forControlStates(ComputerControlState::addReference);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.forControlStates(ComputerControlState::removeReference);
    }

    private void forControlStates(Consumer<ComputerControlState> runner) {
        T t = this.object;
        if (t instanceof ComputerControllable) {
            ComputerControllable controllable = (ComputerControllable)t;
            controllable.getAllComputerControlStates().forEach(runner);
        }
        if (!((t = this.object) instanceof IMultiblockBE)) {
            return;
        }
        IMultiblockBE multiblockBE = (IMultiblockBE)t;
        ApiUtils.addFutureServerTask(this.object.m_58904_(), () -> {
            IMultiblockBEHelper helper = multiblockBE.getHelper();
            for (MultiblockRegistration.ExtraComponent component : helper.getMultiblock().extraComponents()) {
                IMultiblockComponent.StateWrapper patt3312$temp = component.makeWrapper();
                if (!(patt3312$temp instanceof RedstoneControl)) continue;
                RedstoneControl control = (RedstoneControl)patt3312$temp;
                this.callOn(runner, control, helper.getState());
            }
        });
    }

    private <S> void callOn(Consumer<ComputerControlState> runner, RedstoneControl<S> control, Object state) {
        if (state != null) {
            Object rsState = control.wrapState(state);
            runner.accept(((RedstoneControl.RSState)rsState).getComputerControlState());
        }
    }
}

