/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnInterdictionHandler {
    private static final Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> interdictionTiles = new HashMap<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>>();

    @SubscribeEvent
    public static void onEnderTeleport(EntityTeleportEvent.EnderEntity event) {
        if (SpawnInterdictionHandler.shouldCancel(event.getEntity()) || event.getEntityLiving().m_21124_((MobEffect)IEPotions.STUNNED.get()) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawnCheck(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY || event.getSpawner() != null) {
            return;
        }
        if (SpawnInterdictionHandler.shouldCancel((Entity)event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldCancel(Entity entity) {
        if (entity.m_6095_().m_20674_() != MobCategory.MONSTER) {
            return false;
        }
        ResourceKey dimension = entity.m_9236_().m_46472_();
        Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
        synchronized (map) {
            if (!interdictionTiles.containsKey(dimension)) {
                return false;
            }
            Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.get(dimension).iterator();
            while (it.hasNext()) {
                Vec3 tilePos;
                IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                if (!(interdictor instanceof BlockEntity)) continue;
                BlockEntity interdictorTE = (BlockEntity)interdictor;
                if (interdictorTE.m_58901_() || interdictorTE.m_58904_() == null) {
                    it.remove();
                    continue;
                }
                if (!SafeChunkUtils.isChunkSafe((LevelAccessor)interdictorTE.m_58904_(), interdictorTE.m_58899_()) || !((tilePos = Vec3.m_82512_((Vec3i)interdictorTE.m_58899_())).m_82557_(entity.m_20182_()) <= interdictor.getInterdictionRangeSquared())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BlockEntity> void removeFromInterdictionTiles(T tile) {
        Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
        synchronized (map) {
            Set<IEBlockInterfaces.ISpawnInterdiction> inDimension = interdictionTiles.get(tile.m_58904_().m_46472_());
            if (inDimension != null) {
                inDimension.remove(tile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BlockEntity> void addInterdictionTile(T tile) {
        Level world = tile.m_58904_();
        if (world != null && ((Boolean)IEServerConfig.MACHINES.floodlight_spawnPrevent.get()).booleanValue()) {
            Map<ResourceKey<Level>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set forDim = interdictionTiles.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), x -> new HashSet());
                forDim.add((IEBlockInterfaces.ISpawnInterdiction)tile);
            }
        }
    }
}

