/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.items.PotionBucketItem;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionFluid
extends Fluid {
    public static FluidStack getFluidStackForType(Potion type, int amount) {
        if (type == Potions.f_43599_ || type == null) {
            return new FluidStack((Fluid)Fluids.f_76193_, amount);
        }
        FluidStack stack = new FluidStack((Fluid)IEFluids.POTION.get(), amount);
        stack.getOrCreateTag().m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)type).toString());
        return stack;
    }

    public static Potion getType(FluidStack stack) {
        return PotionFluid.fromTag(stack.getTag());
    }

    public static Potion fromTag(@Nullable CompoundTag tag) {
        if (tag == null || !tag.m_128425_("Potion", 8)) {
            return Potions.f_43599_;
        }
        ResourceLocation name = ResourceLocation.m_135820_((String)tag.m_128461_("Potion"));
        if (name == null) {
            return Potions.f_43599_;
        }
        Potion result = (Potion)ForgeRegistries.POTIONS.getValue(name);
        return result == Potions.f_43598_ ? Potions.f_43599_ : result;
    }

    @Nonnull
    public Item m_6859_() {
        return IEItems.Misc.POTION_BUCKET.get();
    }

    protected boolean m_5486_(@Nonnull FluidState fluidState, @Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull Fluid fluid, @Nonnull Direction direction) {
        return true;
    }

    @Nonnull
    protected Vec3 m_7000_(@Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        return Vec3.f_82478_;
    }

    public int m_6718_(LevelReader p_205569_1_) {
        return 0;
    }

    protected float m_6752_() {
        return 0.0f;
    }

    public float m_6098_(@Nonnull FluidState p_215662_1_, @Nonnull BlockGetter p_215662_2_, @Nonnull BlockPos p_215662_3_) {
        return 0.0f;
    }

    public float m_7427_(@Nonnull FluidState p_223407_1_) {
        return 0.0f;
    }

    @Nonnull
    protected BlockState m_5804_(@Nonnull FluidState state) {
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_7444_(@Nonnull FluidState state) {
        return true;
    }

    public int m_7430_(@Nonnull FluidState state) {
        return 0;
    }

    @Nonnull
    public VoxelShape m_7999_(@Nonnull FluidState p_215664_1_, @Nonnull BlockGetter p_215664_2_, @Nonnull BlockPos p_215664_3_) {
        return Shapes.m_83040_();
    }

    @Nonnull
    public FluidType getFluidType() {
        return (FluidType)IEFluids.POTION_TYPE.get();
    }

    public void addInformation(FluidStack fluidStack, Consumer<Component> tooltip) {
        if (fluidStack != null && fluidStack.hasTag()) {
            List effects = PotionUtils.m_43566_((CompoundTag)fluidStack.getTag());
            if (effects.isEmpty()) {
                tooltip.accept((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
            } else {
                for (MobEffectInstance instance : effects) {
                    MutableComponent itextcomponent = Component.m_237115_((String)instance.m_19576_());
                    MobEffect effect = instance.m_19544_();
                    if (instance.m_19564_() > 0) {
                        itextcomponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + instance.m_19564_())));
                    }
                    if (instance.m_19557_() > 20) {
                        itextcomponent.m_130946_(" (").m_7220_(MobEffectUtil.m_267641_((MobEffectInstance)instance, (float)1.0f)).m_130946_(")");
                    }
                    tooltip.accept((Component)itextcomponent.m_130940_(effect.m_19483_().m_19497_()));
                }
            }
            Potion potionType = PotionUtils.m_43577_((CompoundTag)fluidStack.getTag());
            if (potionType != Potions.f_43598_) {
                String modID = BuiltInRegistries.f_256980_.m_7981_((Object)potionType).m_135827_();
                tooltip.accept((Component)Component.m_237110_((String)"desc.immersiveengineering.info.potionMod", (Object[])new Object[]{Utils.getModName(modID)}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public static class PotionFluidType
    extends FluidType {
        private static final ResourceLocation TEXTURE_STILL = ImmersiveEngineering.rl("block/fluid/potion_still");
        private static final ResourceLocation TEXTURE_FLOW = ImmersiveEngineering.rl("block/fluid/potion_flow");

        public PotionFluidType() {
            super(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_));
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return TEXTURE_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return TEXTURE_FLOW;
                }

                public int getTintColor(FluidStack stack) {
                    if (stack == null || !stack.hasTag()) {
                        return -16776961;
                    }
                    return 0xFF000000 | PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)stack.getTag()));
                }
            });
        }

        public Component getDescription(FluidStack stack) {
            if (stack == null || !stack.hasTag()) {
                return super.getDescription(stack);
            }
            return Component.m_237115_((String)PotionUtils.m_43577_((CompoundTag)stack.getTag()).m_43492_("item.minecraft.potion.effect."));
        }

        public ItemStack getBucket(FluidStack stack) {
            return PotionBucketItem.forPotion(PotionFluid.getType(stack));
        }
    }
}

