/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.inventory.IDropInventory;
import com.google.common.collect.Streams;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CraftingTableBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IInteractionObjectIE<CraftingTableBlockEntity>,
IDropInventory {
    public static final int GRID_SIZE = 3;
    public static final int STORAGE_SIZE = 18;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> craftingInv = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private final ResettableCapability<IItemHandler> inventoryCap = this.registerCapability(new ItemStackHandler(this.inventory){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CraftingTableBlockEntity.this.m_6596_();
        }
    });

    public CraftingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CRAFTING_TABLE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (!descPacket) {
            int i;
            NonNullList totalInv = NonNullList.m_122780_((int)(this.inventory.size() + this.craftingInv.size()), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)nbt, (NonNullList)totalInv);
            for (i = 0; i < this.inventory.size(); ++i) {
                this.inventory.set(i, (Object)((ItemStack)totalInv.get(i)));
            }
            for (i = 0; i < this.craftingInv.size(); ++i) {
                this.craftingInv.set(i, (Object)((ItemStack)totalInv.get(this.inventory.size() + i)));
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (!descPacket) {
            int i;
            NonNullList totalInv = NonNullList.m_122780_((int)(this.inventory.size() + this.craftingInv.size()), (Object)ItemStack.f_41583_);
            for (i = 0; i < this.inventory.size(); ++i) {
                totalInv.set(i, (Object)((ItemStack)this.inventory.get(i)));
            }
            for (i = 0; i < this.craftingInv.size(); ++i) {
                totalInv.set(this.inventory.size() + i, (Object)((ItemStack)this.craftingInv.get(i)));
            }
            ContainerHelper.m_18973_((CompoundTag)nbt, (NonNullList)totalInv);
        }
    }

    @Override
    @Nonnull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.immersiveengineering.craftingtable");
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public CraftingTableBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEMenuTypes.ArgContainer<CraftingTableBlockEntity, ?> getContainerType() {
        return IEMenuTypes.CRAFTING_TABLE;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    public NonNullList<ItemStack> getCraftingInventory() {
        return this.craftingInv;
    }

    @Override
    public Stream<ItemStack> getDroppedItems() {
        return Streams.concat((Stream[])new Stream[]{this.craftingInv.stream(), this.inventory.stream()});
    }
}

