/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingMachineLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class BottlingInsertionHandler
implements IItemHandler {
    private final Supplier<Level> level;
    private final MultiblockProcessor.InWorldProcessor<BottlingMachineRecipe> processor;
    private final BottlingMachineLogic.State state;

    public BottlingInsertionHandler(Supplier<Level> level, MultiblockProcessor.InWorldProcessor<BottlingMachineRecipe> processor, BottlingMachineLogic.State state) {
        this.level = level;
        this.processor = processor;
        this.state = state;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        BottlingProcess process;
        stack = stack.m_41777_();
        BottlingMachineRecipe recipe = BottlingMachineRecipe.findRecipe(this.level.get(), this.state.tank.getFluid(), stack);
        if (recipe == null && !Utils.isFluidRelatedItemStack(stack)) {
            return stack;
        }
        int inputAmount = 1;
        if (recipe == null) {
            process = new BottlingProcess(Utils.createNonNullItemStackListFromItemStack(stack.m_41777_()), this.state);
        } else {
            ItemStack displayStack = recipe.getDisplayStack(stack);
            process = new BottlingProcess(recipe, Utils.createNonNullItemStackListFromItemStack(displayStack), this.state);
            inputAmount = displayStack.m_41613_();
        }
        if (this.processor.addProcessToQueue(process, this.level.get(), simulate)) {
            stack.m_41774_(inputAmount);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

