/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.RefineryRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.RefineryShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RefineryLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_POS = new BlockPos(4, 1, 2);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(2, 1, 0, RelativeBlockFace.UP);
    private static final MultiblockFace FLUID_OUTPUT = new MultiblockFace(2, 0, 3, RelativeBlockFace.FRONT);
    private static final CapabilityPosition FLUID_OUTPUT_CAP = CapabilityPosition.opposing(FLUID_OUTPUT);
    private static final Set<CapabilityPosition> FLUID_INPUT_CAPS = Set.of(new CapabilityPosition(0, 0, 1, RelativeBlockFace.RIGHT), new CapabilityPosition(4, 0, 1, RelativeBlockFace.LEFT));
    private static final Set<BlockPos> FLUID_INPUTS = FLUID_INPUT_CAPS.stream().map(CapabilityPosition::posInMultiblock).collect(Collectors.toSet());
    private static final int SLOT_CATALYST = 0;
    private static final int SLOT_CONTAINER_IN = 1;
    private static final int SLOT_CONTAINER_OUT = 2;
    public static final int NUM_SLOTS = 3;
    public static final int ENERGY_CAPACITY = 16000;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        state.active = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        this.tryEnqueueProcess(state, context.getLevel().getRawLevel());
        FluidUtils.multiblockFluidOutput(state.fluidOutput, state.tanks.output(), 1, 2, state.inventory);
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.active, context.isValid(), soundPos, IESounds.refinery);
        }
    }

    private void tryEnqueueProcess(State state, Level level) {
        if (state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        FluidStack leftInput = state.tanks.leftInput.getFluid();
        FluidStack rightInput = state.tanks.rightInput.getFluid();
        if (leftInput.isEmpty() && rightInput.isEmpty()) {
            return;
        }
        ItemStack catalyst = state.inventory.getStackInSlot(0);
        RefineryRecipe recipe = RefineryRecipe.findRecipe(level, leftInput, rightInput, catalyst);
        if (recipe == null) {
            return;
        }
        MultiblockProcessInMachine<RefineryRecipe> process = new MultiblockProcessInMachine<RefineryRecipe>(recipe, new int[0]);
        if (!leftInput.isEmpty() && !rightInput.isEmpty()) {
            process.setInputTanks(0, 1);
        } else if (!leftInput.isEmpty()) {
            process.setInputTanks(0);
        } else {
            process.setInputTanks(1);
        }
        state.processor.addProcessToQueue(process, level, false);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && ENERGY_POS.equalsOrNullFace(position)) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (FLUID_OUTPUT_CAP.equals(position)) {
                return state.outputCap.cast(ctx);
            }
            if (FLUID_INPUT_CAPS.contains(position)) {
                return state.inputCap.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (isClient) {
            return InteractionResult.SUCCESS;
        }
        State state = ctx.getState();
        FluidTank tank = null;
        if (FLUID_INPUTS.contains(posInMultiblock)) {
            tank = posInMultiblock.m_123341_() < 2 ? state.tanks.leftInput : state.tanks.rightInput;
        } else if (FLUID_OUTPUT_CAP.posInMultiblock().equals((Object)posInMultiblock)) {
            tank = state.tanks.output;
        }
        if (tank != null) {
            FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)tank);
            ctx.markMasterDirty();
        } else {
            player.m_5893_(IEMenuTypes.REFINERY.provide(ctx, posInMultiblock));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return RefineryShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<RefineryRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final RefineryTanks tanks = new RefineryTanks();
        private final MultiblockProcessor.InMachineProcessor<RefineryRecipe> processor;
        public final SlotwiseItemHandler inventory;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final IFluidTank[] tankArray;
        private final CapabilityReference<IFluidHandler> fluidOutput;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final StoredCapability<IFluidHandler> inputCap;
        private final StoredCapability<IFluidHandler> outputCap;
        public boolean active;
        private BooleanSupplier isSoundPlaying;

        public State(IInitialMultiblockContext<State> ctx) {
            this.tankArray = new IFluidTank[]{this.tanks.leftInput, this.tanks.rightInput, this.tanks.output};
            this.isSoundPlaying = () -> false;
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            this.processor = new MultiblockProcessor.InMachineProcessor<RefineryRecipe>(1, 0.0f, 1, markDirty, RefineryRecipe.RECIPES::getById);
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 3)), ctx.getMarkDirtyRunnable());
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, FLUID_OUTPUT);
            this.energyCap = new StoredCapability<AveragingEnergyStorage>(this.energy);
            this.inputCap = new StoredCapability<ArrayFluidHandler>(new ArrayFluidHandler(false, true, markDirty, new IFluidTank[]{this.tanks.leftInput, this.tanks.rightInput}));
            this.outputCap = new StoredCapability<ArrayFluidHandler>(ArrayFluidHandler.drainOnly((IFluidTank)this.tanks.output, markDirty));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("tanks", this.tanks.toNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tanks.readNBT(nbt.m_128469_("tanks"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return this.tankArray;
        }

        @Override
        public int[] getOutputTanks() {
            return new int[]{2};
        }
    }

    public record RefineryTanks(FluidTank leftInput, FluidTank rightInput, FluidTank output) {
        public static final int VOLUME = 24000;

        public RefineryTanks() {
            this(new FluidTank(24000), new FluidTank(24000), new FluidTank(24000));
        }

        public Tag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("leftIn", (Tag)this.leftInput.writeToNBT(new CompoundTag()));
            tag.m_128365_("rightIn", (Tag)this.rightInput.writeToNBT(new CompoundTag()));
            tag.m_128365_("out", (Tag)this.output.writeToNBT(new CompoundTag()));
            return tag;
        }

        public void readNBT(CompoundTag tag) {
            this.leftInput.readFromNBT(tag.m_128469_("leftIn"));
            this.rightInput.readFromNBT(tag.m_128469_("rightIn"));
            this.output.readFromNBT(tag.m_128469_("out"));
        }
    }
}

