/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.AutoWorkbenchShapes;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class AutoWorkbenchLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final int BLUEPRINT_SLOT = 0;
    public static final int FIRST_INPUT_SLOT = 1;
    public static final int NUM_INPUT_SLOTS = 16;
    public static final int NUM_SLOTS = 17;
    public static final int ENERGY_CAPACITY = 32000;
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(3, 1, 1, RelativeBlockFace.RIGHT);
    private static final BlockPos INPUT_POS = new BlockPos(0, 1, 2);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    public static final BlockPos REDSTONE_POS = new BlockPos(1, 0, 2);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        BlueprintCraftingRecipe recipe;
        State state = context.getState();
        boolean isRSEnabled = state.rsState.isEnabled(context);
        boolean active = state.processor.tickServer(state, context.getLevel(), isRSEnabled);
        if (active != state.active) {
            state.active = active;
            context.requestMasterBESync();
        }
        if (!context.getLevel().shouldTickModulo(16)) {
            return;
        }
        if (!isRSEnabled || state.inventory.getStackInSlot(0).m_41619_()) {
            return;
        }
        BlueprintCraftingRecipe[] recipes = AutoWorkbenchLogic.getAvailableRecipes(context.getLevel().getRawLevel(), state);
        if (state.selectedRecipe >= 0 && state.selectedRecipe < recipes.length && (recipe = recipes[state.selectedRecipe]) != null && !((ItemStack)recipe.output.get()).m_41619_()) {
            NonNullList query = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
            for (int i = 0; i < query.size(); ++i) {
                query.set(i, (Object)state.inventory.getStackInSlot(i + 1));
            }
            int crafted = recipe.getMaxCrafted((NonNullList<ItemStack>)query);
            if (crafted > 0 && state.processor.addProcessToQueue(new MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, (NonNullList<ItemStack>)NonNullList.m_122779_()), context.getLevel().getRawLevel(), true)) {
                state.processor.addProcessToQueue(new MultiblockProcessInWorld<BlueprintCraftingRecipe>(recipe, 0.78f, recipe.consumeInputs((NonNullList<ItemStack>)query, 1)), context.getLevel().getRawLevel(), false);
                for (int i = 0; i < query.size(); ++i) {
                    state.inventory.setStackInSlot(i + 1, (ItemStack)query.get(i));
                }
            }
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        if (context.getState().active) {
            for (MultiblockProcess process : context.getState().processor.getQueue()) {
                ++process.processTick;
            }
        }
    }

    public static BlueprintCraftingRecipe[] getAvailableRecipes(Level level, State state) {
        return EngineersBlueprintItem.getRecipes(level, state.inventory.getStackInSlot(0));
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && INPUT_POS.equals((Object)position.posInMultiblock())) {
            return ctx.getState().input.cast(ctx);
        }
        if (cap == ForgeCapabilities.ENERGY && ENERGY_POS.equalsOrNullFace(position)) {
            return ctx.getState().energyCap.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return AutoWorkbenchShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(ComparatorManager.SimpleComparatorValue.inventory(ProcessContext::getInventory, 1, 16), REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<BlueprintCraftingRecipe> {
        public final SlotwiseItemHandler inventory;
        public int selectedRecipe = -1;
        public final MultiblockProcessor.InWorldProcessor<BlueprintCraftingRecipe> processor;
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public boolean active;
        private final DroppingMultiblockOutput output;
        private final StoredCapability<IItemHandler> input;
        private final StoredCapability<IEnergyStorage> energyCap = new StoredCapability<AveragingEnergyStorage>(this.energy);

        public State(IInitialMultiblockContext<State> ctx) {
            this.processor = new MultiblockProcessor.InWorldProcessor<BlueprintCraftingRecipe>(3, $ -> 0.4375, 3, ctx.getMarkDirtyRunnable(), ctx.getSyncRunnable(), BlueprintCraftingRecipe.RECIPES::getById);
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(new SlotwiseItemHandler.IOConstraint(true, i -> i.m_150930_(IEItems.Misc.BLUEPRINT.m_5456_())), 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 17)), ctx.getMarkDirtyRunnable());
            this.input = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(1, 17)));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128405_("selectedRecipe", this.selectedRecipe);
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128365_("energy", this.energy.serializeNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.selectedRecipe = nbt.m_128451_("selectedRecipe");
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInWorld::new);
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128365_("processor", this.processor.toNBT());
            nbt.m_128379_("active", this.active);
            nbt.m_128365_("blueprint", (Tag)this.inventory.getStackInSlot(0).m_41739_(new CompoundTag()));
            nbt.m_128405_("selectedRecipe", this.selectedRecipe);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInWorld::new);
            this.active = nbt.m_128471_("active");
            this.inventory.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("blueprint")));
            this.selectedRecipe = nbt.m_128451_("selectedRecipe");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public void doProcessOutput(ItemStack result, IMultiblockLevel level) {
            this.output.insertOrDrop(result, level);
        }
    }
}

