/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.client.fx.CustomParticleManager;
import blusunrize.immersiveengineering.client.utils.DistField;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3f;

public class ClocheBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IIEInventory,
IEBlockInterfaces.IInteractionObjectIE<ClocheBlockEntity>,
IModelOffsetProvider {
    public static final int SLOT_SOIL = 0;
    public static final int SLOT_SEED = 1;
    public static final int SLOT_FERTILIZER = 2;
    public static final int NUM_SLOTS = 7;
    public static final int TANK_CAPACITY = 4000;
    public static final int ENERGY_CAPACITY = 16000;
    public int dummy = 0;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);
    public final FluidTank tank = new FluidTank(4000){

        public boolean isFluidValid(FluidStack fluid) {
            return fluid.getFluid().m_205067_(FluidTags.f_13131_);
        }
    };
    public MutableEnergyStorage energyStorage;
    public final DistField<CustomParticleManager> particles;
    public final Supplier<ClocheRecipe> cachedRecipe;
    public int fertilizerAmount;
    public float fertilizerMod;
    private float growth;
    public float renderGrowth;
    public boolean renderActive;
    private final CapabilityReference<IItemHandler> output;
    private final MultiblockCapability<IItemHandler> inputHandler;
    private final MultiblockCapability<IItemHandler> outputHandler;
    private final MultiblockCapability<IFluidHandler> tankCap;
    private final MultiblockCapability<IEnergyStorage> energyCap;
    private AABB renderBB;

    public ClocheBlockEntity(BlockEntityType<ClocheBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyStorage = new MutableEnergyStorage(16000, Math.max(256, IEServerConfig.getOrDefault(IEServerConfig.MACHINES.cloche_consumption)));
        this.particles = DistField.client(() -> CustomParticleManager::new);
        this.cachedRecipe = CachedRecipe.cached(ClocheRecipe::findRecipe, () -> this.f_58857_, () -> (ItemStack)this.inventory.get(1), () -> (ItemStack)this.inventory.get(0));
        this.fertilizerAmount = 0;
        this.fertilizerMod = 1.0f;
        this.growth = 0.0f;
        this.renderGrowth = 0.0f;
        this.renderActive = false;
        this.output = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.f_58858_.m_7494_().m_121945_(this.getFacing().m_122424_()), this.getFacing()), ForgeCapabilities.ITEM_HANDLER);
        this.inputHandler = MultiblockCapability.make(this, be -> be.inputHandler, ClocheBlockEntity::master, this.registerCapability(new IEInventoryHandler(1, (IIEInventory)this, 2, true, false)));
        this.outputHandler = MultiblockCapability.make(this, be -> be.outputHandler, ClocheBlockEntity::master, this.registerCapability(new IEInventoryHandler(4, (IIEInventory)this, 3, false, true)));
        this.tankCap = MultiblockCapability.make(this, be -> be.tankCap, ClocheBlockEntity::master, this.registerCapability(this.tank));
        this.energyCap = MultiblockCapability.make(this, be -> be.energyCap, ClocheBlockEntity::master, this.registerEnergyInput(this.energyStorage));
    }

    @Override
    public boolean canTickAny() {
        return !this.isRSPowered();
    }

    @Override
    public void tickClient() {
        ClocheRecipe recipe;
        this.particles.get().clientTick();
        ItemStack seed = (ItemStack)this.inventory.get(1);
        ItemStack soil = (ItemStack)this.inventory.get(0);
        if (this.renderActive && (recipe = this.cachedRecipe.get()) != null && this.fertilizerAmount > 0) {
            double addGrow = (Double)IEServerConfig.MACHINES.cloche_growth_mod.get() * (double)this.fertilizerMod;
            this.renderGrowth = (double)this.renderGrowth < (double)recipe.getTime(seed, soil) + addGrow ? (float)((double)this.renderGrowth + addGrow) : 0.0f;
            if (ApiUtils.RANDOM.nextInt(8) == 0) {
                this.particles.get().add(new DustParticleOptions(new Vector3f(0.55f, 0.1f, 0.1f), 1.0f), 0.5, 2.6875, 0.5, 0.25, 0.25, 0.25, 20);
            }
        }
    }

    @Override
    public void tickServer() {
        IItemHandler outputHandler;
        ItemStack seed = (ItemStack)this.inventory.get(1);
        ItemStack soil = (ItemStack)this.inventory.get(0);
        if (!seed.m_41619_()) {
            ClocheRecipe recipe = this.cachedRecipe.get();
            int consumption = (Integer)IEServerConfig.MACHINES.cloche_consumption.get();
            if (recipe != null && this.fertilizerAmount > 0 && this.energyStorage.extractEnergy(consumption, true) == consumption) {
                boolean consume = false;
                if (this.growth >= (float)recipe.getTime(seed, soil)) {
                    ItemStack existing;
                    int j;
                    List<Lazy<ItemStack>> outputs = recipe.getOutputs(seed, soil);
                    int canFit = 0;
                    boolean[] emptySlotsUsed = new boolean[4];
                    block0: for (Lazy<ItemStack> output : outputs) {
                        if (((ItemStack)output.get()).m_41619_()) continue;
                        for (j = 3; j < 7; ++j) {
                            existing = (ItemStack)this.inventory.get(j);
                            if ((!existing.m_41619_() || emptySlotsUsed[j - 3]) && (!ItemHandlerHelper.canItemStacksStack((ItemStack)existing, (ItemStack)((ItemStack)output.get())) || existing.m_41613_() + ((ItemStack)output.get()).m_41613_() > existing.m_41741_())) continue;
                            ++canFit;
                            if (!existing.m_41619_()) continue block0;
                            emptySlotsUsed[j - 3] = true;
                            continue block0;
                        }
                    }
                    if (canFit >= outputs.size()) {
                        block2: for (Lazy<ItemStack> output : outputs) {
                            for (j = 3; j < 7; ++j) {
                                existing = (ItemStack)this.inventory.get(j);
                                if (existing.m_41619_()) {
                                    this.inventory.set(j, (Object)((ItemStack)output.get()).m_41777_());
                                    continue block2;
                                }
                                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)existing, (ItemStack)((ItemStack)output.get())) || existing.m_41613_() + ((ItemStack)output.get()).m_41613_() > existing.m_41741_()) continue;
                                existing.m_41769_(((ItemStack)output.get()).m_41613_());
                                continue block2;
                            }
                        }
                        this.growth = 0.0f;
                        consume = true;
                    }
                } else {
                    this.growth = (float)((double)this.growth + (Double)IEServerConfig.MACHINES.cloche_growth_mod.get() * (double)this.fertilizerMod);
                    consume = true;
                    if (this.f_58857_.m_46467_() % 32L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x1F)) {
                        this.sendSyncPacket();
                    }
                }
                if (consume) {
                    this.energyStorage.extractEnergy(consumption, false);
                    --this.fertilizerAmount;
                    if (!this.renderActive) {
                        this.renderActive = true;
                        this.sendSyncPacket();
                    }
                } else if (this.renderActive) {
                    this.renderActive = false;
                    this.sendSyncPacket();
                }
            } else {
                this.growth = 0.0f;
            }
            int fluidConsumption = (Integer)IEServerConfig.MACHINES.cloche_fluid.get();
            if (this.fertilizerAmount <= 0 && this.tank.getFluidAmount() >= fluidConsumption) {
                float itemMod;
                this.fertilizerMod = 1.0f;
                this.tank.drain(fluidConsumption, IFluidHandler.FluidAction.EXECUTE);
                ItemStack fertilizer = (ItemStack)this.inventory.get(2);
                if (!fertilizer.m_41619_() && (itemMod = ClocheFertilizer.getFertilizerGrowthModifier(this.f_58857_, fertilizer)) > 0.0f) {
                    this.fertilizerMod *= itemMod;
                    fertilizer.m_41774_(1);
                    if (fertilizer.m_41613_() <= 0) {
                        this.inventory.set(2, (Object)ItemStack.f_41583_);
                    }
                }
                this.fertilizerAmount = (Integer)IEServerConfig.MACHINES.cloche_fertilizer.get();
            }
        } else {
            this.growth = 0.0f;
        }
        if (this.f_58857_.m_46467_() % 8L == 0L && (outputHandler = this.output.getNullable()) != null) {
            for (int j = 3; j < 7; ++j) {
                ItemStack outStack = (ItemStack)this.inventory.get(j);
                if (outStack.m_41619_()) continue;
                int outCount = Math.min(outStack.m_41613_(), 16);
                ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)outStack, (int)outCount);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).m_41619_()) {
                    outCount -= stack.m_41613_();
                }
                outStack.m_41774_(outCount);
                if (outStack.m_41613_() > 0) continue;
                this.inventory.set(j, (Object)ItemStack.f_41583_);
            }
        }
    }

    public float getGuiProgress() {
        ItemStack seed = (ItemStack)this.inventory.get(1);
        ItemStack soil = (ItemStack)this.inventory.get(0);
        ClocheRecipe recipe = this.cachedRecipe.get();
        if (recipe == null) {
            return 0.0f;
        }
        return Mth.m_14036_((float)(this.renderGrowth / (float)recipe.getTime(seed, soil)), (float)0.0f, (float)1.0f);
    }

    protected void sendSyncPacket() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("growth", this.growth);
        nbt.m_128379_("renderActive", this.renderActive);
        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new MessageBlockEntitySync(this, nbt));
    }

    @Override
    public void receiveMessageFromServer(CompoundTag message) {
        this.renderGrowth = message.m_128457_("growth");
        this.renderActive = message.m_128471_("renderActive");
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.dummy = nbt.m_128451_("dummy");
        Collections.fill(this.inventory, ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.fertilizerAmount = nbt.m_128451_("fertilizerAmount");
        this.fertilizerMod = nbt.m_128457_("fertilizerMod");
        if (!descPacket) {
            EnergyHelper.deserializeFrom(this.energyStorage, nbt);
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.growth = nbt.m_128457_("growth");
        }
        this.renderBB = null;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128405_("dummy", this.dummy);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("fertilizerAmount", this.fertilizerAmount);
        nbt.m_128350_("fertilizerMod", this.fertilizerMod);
        if (!descPacket) {
            EnergyHelper.serializeTo(this.energyStorage, nbt);
            CompoundTag tankTag = this.tank.writeToNBT(new CompoundTag());
            nbt.m_128365_("tank", (Tag)tankTag);
            nbt.m_128350_("growth", this.growth);
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public void setFacing(Direction facing) {
        BlockPos lowest = this.f_58858_.m_6625_(this.dummy);
        for (int i = 0; i < 3; ++i) {
            BlockPos pos = lowest.m_6630_(i);
            BlockState state = this.getLevelNonnull().m_8055_(pos);
            if (state.m_60734_() != IEBlocks.MetalDevices.CLOCHE.get()) continue;
            this.getLevelNonnull().m_46597_(pos, (BlockState)state.m_61124_(this.getFacingProperty(), (Comparable)facing));
        }
    }

    @Override
    public boolean isDummy() {
        return this.dummy != 0;
    }

    @Override
    @Nullable
    public ClocheBlockEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterBE instanceof ClocheBlockEntity) {
            return (ClocheBlockEntity)this.tempMasterBE;
        }
        BlockPos masterPos = this.m_58899_().m_6625_(this.dummy);
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, masterPos);
        return te instanceof ClocheBlockEntity ? (ClocheBlockEntity)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.f_58857_.m_46597_(this.f_58858_.m_6630_(i), state);
            ((ClocheBlockEntity)this.f_58857_.m_7702_((BlockPos)this.f_58858_.m_6630_((int)i))).dummy = i;
            ((ClocheBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_6630_(i))).setFacing(this.getFacing());
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterBE = this.master();
        for (int i = 0; i <= 2; ++i) {
            BlockPos p = this.m_58899_().m_6625_(this.dummy).m_6630_(i);
            if (!(this.f_58857_.m_7702_(p) instanceof ClocheBlockEntity)) continue;
            this.f_58857_.m_7471_(p, false);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (slot == 2) {
            return ClocheFertilizer.isValidFertilizer(this.f_58857_, stack);
        }
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot < 2 ? 1 : 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ENERGY && (facing == null || this.dummy == 0 && facing.m_122434_() == this.getFacing().m_122427_().m_122434_() || this.dummy == 2 && facing == Direction.UP)) {
            return this.energyCap.getAndCast();
        }
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == null || this.dummy == 0 && facing.m_122434_() != this.getFacing().m_122427_().m_122434_()) {
                return this.inputHandler.getAndCast();
            }
            if (this.dummy == 1 && facing == this.getFacing().m_122424_()) {
                return this.outputHandler.getAndCast();
            }
        } else if (capability == ForgeCapabilities.FLUID_HANDLER && (facing == null || this.dummy == 0 && facing.m_122434_() != this.getFacing().m_122427_().m_122434_())) {
            return this.tankCap.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public ClocheBlockEntity getGuiMaster() {
        if (this.dummy == 0) {
            return this;
        }
        BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_6625_(this.dummy));
        if (te instanceof ClocheBlockEntity) {
            return (ClocheBlockEntity)te;
        }
        return null;
    }

    @Override
    public IEMenuTypes.ArgContainer<ClocheBlockEntity, ?> getContainerType() {
        return IEMenuTypes.CLOCHE;
    }

    public AABB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AABB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0).m_82338_(this.f_58858_);
        }
        return this.renderBB;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        return new BlockPos(0, this.dummy, 0);
    }
}

