/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.BatchingRenderTypeBuffer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingMachineLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingProcess;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class BottlingMachineRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<BottlingMachineLogic.State>> {
    public static final String NAME = "bottling_machine_dynamic";
    public static DynamicModel DYNAMIC;

    public void render(MultiblockBlockEntityMaster<BottlingMachineLogic.State> te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IMultiblockBEHelper helper = te.getHelper();
        MultiblockOrientation orientation = helper.getContext().getLevel().getOrientation();
        BottlingMachineLogic.State state = (BottlingMachineLogic.State)helper.getState();
        Direction facing = orientation.front();
        float pixelHeight = 0.0625f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        MultiBufferSource originalBuffer = bufferIn;
        bufferIn = BERenderUtils.mirror(orientation, matrixStack, bufferIn);
        float[][] itemDisplays = new float[state.processor.getQueueSize()][];
        float lift = 0.0f;
        VertexConsumer solidBuilder = bufferIn.m_6299_(RenderType.m_110451_());
        for (int i = 0; i < itemDisplays.length; ++i) {
            float itemX;
            BottlingProcess process = (BottlingProcess)state.processor.getQueue().get(i);
            if (process == null) continue;
            float processMaxTicks = process.getMaxTicks(te.m_58904_());
            float transportTime = BottlingMachineLogic.getTransportTime(processMaxTicks);
            float liftTime = BottlingMachineLogic.getLiftTime(processMaxTicks);
            float fProcess = process.processTick;
            float itemY = 0.0f;
            float itemFill = 0.0f;
            if (fProcess < transportTime) {
                itemX = 0.5f * fProcess / transportTime;
            } else if (fProcess < processMaxTicks - transportTime) {
                itemX = 0.5f;
                if (fProcess < transportTime + liftTime) {
                    lift = (fProcess - transportTime) / liftTime;
                } else if (fProcess < processMaxTicks - (transportTime + liftTime)) {
                    lift = 1.0f;
                    itemFill = (fProcess - (transportTime + liftTime)) / (processMaxTicks - 2.0f * (transportTime + liftTime));
                } else {
                    lift = 1.0f - (fProcess - (processMaxTicks - transportTime - liftTime)) / liftTime;
                    itemFill = 1.0f;
                }
                lift *= 0.125f;
                if (lift > 0.0625f) {
                    itemY += lift - 0.0625f;
                }
            } else {
                itemX = 0.5f + 0.5f * (fProcess - (processMaxTicks - transportTime)) / transportTime;
                itemFill = 1.0f;
            }
            itemDisplays[i] = new float[]{fProcess, (itemX - 0.5f) * 2.5f, itemY - 0.15625f, 1.0f, itemFill};
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, lift, 0.0f);
        BottlingMachineRenderer.renderModelPart(matrixStack, solidBuilder, facing, combinedLightIn, combinedOverlayIn, "lift");
        matrixStack.m_252880_(0.0f, -lift, 0.0f);
        matrixStack.m_85849_();
        float dir = facing == Direction.SOUTH ? (float)Math.PI : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -1.5707964f : 1.5707964f));
        matrixStack.m_252781_(new Quaternionf().rotateY(dir));
        float scale = 0.0625f;
        FluidStack fs = state.tank.getFluid();
        if (!fs.isEmpty()) {
            float tankWidth = 7.0f;
            matrixStack.m_85836_();
            float level = (float)fs.getAmount() / (float)state.tank.getCapacity();
            matrixStack.m_85837_(-0.21875, 0.376, 1.21875);
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_252880_(3.5f, 0.0f, -3.5f);
            float h = level * 9.0f;
            VertexConsumer builder = originalBuffer.m_6299_(RenderType.m_110466_());
            for (int i = 0; i < 4; ++i) {
                matrixStack.m_85836_();
                matrixStack.m_252880_(0.0f, 0.0f, -3.5f);
                GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, 0.0f, 7.0f, h);
                matrixStack.m_85849_();
                matrixStack.m_252781_(new Quaternionf().rotateY(1.5707964f));
            }
            matrixStack.m_252781_(new Quaternionf().rotateX(-1.5707964f));
            GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.m_252781_(new Quaternionf().rotateX((float)Math.PI));
            matrixStack.m_252880_(0.0f, 0.0f, -h);
            GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.m_85849_();
        }
        for (int i = 0; i < itemDisplays.length; ++i) {
            BottlingProcess process;
            if (itemDisplays[i] == null || (process = (BottlingProcess)state.processor.getQueue().get(i)) == null) continue;
            List<ItemStack> display = process.getDisplayItem(te.m_58904_());
            scale = 0.4375f;
            matrixStack.m_252880_(itemDisplays[i][1], itemDisplays[i][2], itemDisplays[i][3]);
            matrixStack.m_85841_(scale, scale, scale);
            if (!ClientUtils.mc().m_91385_().isStencilEnabled()) {
                for (ItemStack displayS : display) {
                    ClientUtils.mc().m_91291_().m_269128_(displayS, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, te.m_58904_(), 0);
                }
            } else {
                float h0 = -0.5f;
                float h1 = h0 + itemDisplays[i][4];
                for (ItemStack inputS : process.inputItems) {
                    this.renderItemPart(bufferIn, matrixStack, inputS, h0, h1, combinedLightIn, combinedOverlayIn, 0, te.m_58904_());
                }
                for (ItemStack displayS : display) {
                    this.renderItemPart(bufferIn, matrixStack, displayS, h0, h1, combinedLightIn, combinedOverlayIn, 1, te.m_58904_());
                }
            }
            matrixStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
            matrixStack.m_252880_(-itemDisplays[i][1], -itemDisplays[i][2], -itemDisplays[i][3]);
        }
        matrixStack.m_85849_();
    }

    public static void renderModelPart(PoseStack matrixStack, VertexConsumer builder, Direction facing, int combinedLightIn, int combinedOverlayIn, String ... parts) {
        ModelData data = ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(parts));
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = DYNAMIC.getNullQuads(data);
        BottlingMachineRenderer.rotateForFacing(matrixStack, facing);
        RenderUtils.renderModelTESRFast(quads, builder, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
    }

    private void renderItemPart(MultiBufferSource baseBuffer, PoseStack matrix, ItemStack item, float minY, float maxY, int combinedLightIn, int combinedOverlayIn, int ref, Level level) {
        PoseStack innerStack = new PoseStack();
        innerStack.m_85850_().m_252922_().mul((Matrix4fc)matrix.m_85850_().m_252922_());
        innerStack.m_85850_().m_252943_().mul((Matrix3fc)matrix.m_85850_().m_252943_());
        MultiBufferSource stencilWrapper = IERenderTypes.wrapWithStencil(baseBuffer, vertexBuilder -> {
            innerStack.m_85836_();
            innerStack.m_252781_(new Quaternionf().rotateY((90.0f - ClientUtils.mc().m_91290_().f_114358_.m_90590_()) * ((float)Math.PI / 180)));
            RenderUtils.renderBox(vertexBuilder, innerStack, -0.5f, minY, -0.5f, 0.5f, maxY, 0.5f);
            innerStack.m_85849_();
        }, "min" + minY + "max" + maxY, ref);
        BatchingRenderTypeBuffer batchBuffer = new BatchingRenderTypeBuffer();
        ClientUtils.mc().m_91291_().m_269128_(item, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrix, (MultiBufferSource)batchBuffer, level, 0);
        batchBuffer.pipe(stencilWrapper);
    }
}

