/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.item;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.gui.RevolverContainer;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RevolverCallbacks
implements ItemCallback<Key> {
    public static final RevolverCallbacks INSTANCE = new RevolverCallbacks();
    public static HashMap<String, TextureAtlasSprite> revolverIcons = new HashMap();
    public static TextureAtlasSprite revolverDefaultTexture;
    private static final List<List<String>> groups;
    private static Transformation matOpen;
    private static Transformation matClose;
    private static Transformation matCylinder;

    public static void retrieveRevolverTextures(TextureAtlas map) {
        revolverDefaultTexture = map.m_118316_(RevolverCallbacks.revolverRL("revolver"));
        for (String key : RevolverItem.specialRevolversByTag.keySet()) {
            if (key.isEmpty() || RevolverItem.specialRevolversByTag.get(key).tag().isEmpty()) continue;
            int split = key.lastIndexOf("_");
            if (split < 0) {
                split = key.length();
            }
            revolverIcons.put(key, map.m_118316_(RevolverCallbacks.revolverRL("revolver_" + key.substring(0, split).toLowerCase(Locale.US))));
        }
    }

    private static ResourceLocation revolverRL(String revolverName) {
        return ImmersiveEngineering.rl("item/revolvers/" + revolverName);
    }

    @Override
    public Key extractKey(ItemStack stack, LivingEntity owner) {
        CompoundTag upgrades = RevolverItem.getUpgradesStatic(stack);
        return new Key(ItemNBTHelper.getString(stack, "elite"), ItemNBTHelper.getString(stack, "flavour"), upgrades.m_128451_("bullets") > 0, upgrades.m_128471_("fancyAnimation"), upgrades.m_128459_("melee") > 0.0, upgrades.m_128471_("electro"), upgrades.m_128471_("scope"), ItemNBTHelper.getInt(stack, "reload"));
    }

    @Override
    public TextureAtlasSprite getTextureReplacement(Key stack, String group, String material) {
        if (!stack.elite().isEmpty()) {
            return revolverIcons.get(stack.elite());
        }
        return revolverDefaultTexture;
    }

    @Override
    public boolean shouldRenderGroup(Key stack, String group, RenderType layer) {
        RevolverItem.SpecialRevolver r;
        if (group.equals("frame") || group.equals("cylinder") || group.equals("barrel") || group.equals("cosmetic_compensator")) {
            return true;
        }
        HashSet<String> render = new HashSet<String>();
        String tag = stack.elite();
        String flavour = stack.flavor();
        if (!tag.isEmpty() && RevolverItem.specialRevolversByTag.containsKey(tag)) {
            RevolverItem.SpecialRevolver r2 = RevolverItem.specialRevolversByTag.get(tag);
            if (r2 != null && r2.renderAdditions() != null) {
                Collections.addAll(render, r2.renderAdditions());
            }
        } else if (!flavour.isEmpty() && RevolverItem.specialRevolversByTag.containsKey(flavour) && (r = RevolverItem.specialRevolversByTag.get(flavour)) != null && r.renderAdditions() != null) {
            Collections.addAll(render, r.renderAdditions());
        }
        if (stack.extraBullets() && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (stack.extraMelee() && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (stack.electro()) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        if (stack.scope()) {
            render.add("dev_scope");
        }
        return render.contains(group);
    }

    @Override
    public void handlePerspective(Key key, LivingEntity holder, ItemDisplayContext cameraItemDisplayContext, PoseStack mat) {
        if (holder instanceof Player) {
            Player player = (Player)holder;
            if (cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                float f;
                boolean left;
                boolean main = (cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) == (holder.m_5737_() == HumanoidArm.RIGHT);
                boolean bl = left = cameraItemDisplayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || cameraItemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                if (key.fancyAnimation() && main && (f = player.m_36403_(ClientUtils.mc().m_91296_())) < 1.0f) {
                    float angle = f * -6.28318f;
                    if (left) {
                        angle *= -1.0f;
                    }
                    mat.m_85837_(0.0, 1.5 - (double)f, 0.0);
                    mat.m_252781_(new Quaternionf().rotateXYZ(0.0f, 0.0f, angle));
                }
                if (key.reload() > 0) {
                    f = 3.0f - (float)key.reload / 20.0f;
                    if ((double)f > 0.35 && (double)f < 1.95) {
                        if ((double)f < 0.5) {
                            mat.m_85837_((0.35 - (double)f) * 2.0, 0.0, 0.0);
                            mat.m_252781_(new Quaternionf().rotateAxis(2.64f * (f - 0.35f), (Vector3fc)new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f)));
                        } else if ((double)f < 0.6) {
                            mat.m_85837_(((double)f - 0.5) * 6.0, (0.5 - (double)f) * 1.0, 0.0);
                            mat.m_252781_(new Quaternionf().rotateAxis(0.87266f, (Vector3fc)new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f)));
                        } else if ((double)f < 1.7) {
                            mat.m_85837_(0.0, -0.6, 0.0);
                            mat.m_252781_(new Quaternionf().rotateAxis(0.87266f, (Vector3fc)new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f)));
                        } else if ((double)f < 1.8) {
                            mat.m_85837_((1.8 - (double)f) * 6.0, ((double)f - 1.8) * 1.0, 0.0);
                            mat.m_252781_(new Quaternionf().rotateAxis(0.87266f, (Vector3fc)new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f)));
                        } else {
                            mat.m_252880_((f - 1.95f) * 2.0f, 0.0f, 0.0f);
                            mat.m_252781_(new Quaternionf().rotateAxis(2.64f * (1.95f - f), (Vector3fc)new Vector3f(0.0f, 0.0f, left ? -1.0f : 1.0f)));
                        }
                    }
                } else if (player.f_36096_ instanceof RevolverContainer) {
                    mat.m_85837_(left ? 0.4 : -0.4, 0.4, 0.0);
                    mat.m_252781_(new Quaternionf().rotateAxis(0.87266f, 0.0f, 0.0f, left ? -1.0f : 1.0f));
                }
            }
        }
    }

    @Override
    public List<List<String>> getSpecialGroups(ItemStack stack, ItemDisplayContext transform, LivingEntity entity) {
        return groups;
    }

    @Override
    @Nonnull
    public Transformation getTransformForGroups(ItemStack stack, List<String> groups, ItemDisplayContext transform, LivingEntity entity, float partialTicks) {
        if (matOpen == null) {
            matOpen = new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternionf().rotateXYZ(0.0f, 0.0f, -0.87266f), null, null);
        }
        if (matClose == null) {
            matClose = new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), null, null, null);
        }
        if (matCylinder == null) {
            matCylinder = new Transformation(new Vector3f(0.0f, 0.6875f, 0.0f), null, null, null);
        }
        if (entity instanceof Player && (transform == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transform == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transform == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transform == ItemDisplayContext.THIRD_PERSON_LEFT_HAND)) {
            boolean main = (transform == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transform == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) == (entity.m_5737_() == HumanoidArm.RIGHT);
            boolean left = transform == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transform == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            ItemStack itemStack = stack = main ? entity.m_21205_() : entity.m_21206_();
            if (ItemNBTHelper.hasKey(stack, "reload")) {
                float f = 3.0f - (float)ItemNBTHelper.getInt(stack, "reload") / 20.0f;
                if ("frame".equals(groups.get(0))) {
                    if ((double)f < 0.35 || (double)f > 1.95) {
                        return matClose;
                    }
                    if ((double)f < 0.5) {
                        return new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternionf().rotateXYZ(0.0f, 0.0f, -2.64f * (f - 0.35f)), null, null);
                    }
                    if ((double)f < 1.8) {
                        return matOpen;
                    }
                    return new Transformation(new Vector3f(-0.625f, 0.25f, 0.0f), new Quaternionf().rotateXYZ(0.0f, 0.0f, -2.64f * (1.95f - f)), null, null);
                }
                if ((double)f > 2.5 && (double)f < 2.9) {
                    float angle = (float)(left ? -1 : 1) * -15.70795f * (f - 2.5f);
                    return new Transformation(new Vector3f(0.0f, 0.6875f, 0.0f), new Quaternionf().rotateXYZ(angle, 0.0f, 0.0f), null, null);
                }
            } else if ("frame".equals(groups.get(0)) && ((Player)entity).f_36096_ instanceof RevolverContainer) {
                return matOpen;
            }
        }
        return "frame".equals(groups.get(0)) ? matClose : matCylinder;
    }

    static {
        groups = List.of(List.of("frame"), List.of("cylinder"));
    }

    public record Key(String elite, String flavor, boolean extraBullets, boolean fancyAnimation, boolean extraMelee, boolean electro, boolean scope, int reload) {
    }
}

