/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.excavator;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;

public class MineralVein {
    private final ColumnPos pos;
    private final ResourceLocation mineralName;
    @Nullable
    private MineralMix mineral;
    private final int radius;
    private int depletion;

    public MineralVein(ColumnPos pos, ResourceLocation mineral, int radius) {
        this.pos = pos;
        this.mineralName = mineral;
        this.radius = radius;
    }

    public ColumnPos getPos() {
        return this.pos;
    }

    @Nullable
    public MineralMix getMineral(Level level) {
        if (this.mineral == null) {
            this.mineral = MineralMix.RECIPES.getById(level, this.mineralName);
        }
        return this.mineral;
    }

    public int getRadius() {
        return this.radius;
    }

    public double getFailChance(BlockPos pos) {
        double dX = pos.m_123341_() - this.pos.f_140723_();
        double dZ = pos.m_123343_() - this.pos.f_140724_();
        double d = (dX * dX + dZ * dZ) / (double)(this.radius * this.radius);
        return d * d * (-2.0 * d + 3.0);
    }

    public int getDepletion() {
        return this.depletion;
    }

    public void setDepletion(int depletion) {
        this.depletion = depletion;
    }

    public void deplete() {
        if (!this.isDepleted()) {
            ++this.depletion;
            ExcavatorHandler.MARK_SAVE_DATA_DIRTY.getValue().run();
        }
    }

    public boolean isDepleted() {
        return ExcavatorHandler.mineralVeinYield > 0 && this.getDepletion() >= ExcavatorHandler.mineralVeinYield;
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", this.pos.f_140723_());
        tag.m_128405_("z", this.pos.f_140724_());
        tag.m_128359_("mineral", this.mineralName.toString());
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("depletion", this.depletion);
        return tag;
    }

    @Nullable
    public static MineralVein readFromNBT(CompoundTag tag) {
        try {
            ColumnPos pos = new ColumnPos(tag.m_128451_("x"), tag.m_128451_("z"));
            ResourceLocation id = new ResourceLocation(tag.m_128461_("mineral"));
            int radius = tag.m_128451_("radius");
            MineralVein info = new MineralVein(pos, id, radius);
            info.depletion = tag.m_128451_("depletion");
            return info;
        }
        catch (ResourceLocationException ex) {
            return null;
        }
    }
}

