/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.AABB;

public class ResizeFrameScreen
extends AbstractContainerScreen<AbstractContainerMenu> {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/resize_frame.png");
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 50;
    private UUID uuid;
    private float visibility;
    private Button visibilityButton;
    private long lastCheck;

    public ResizeFrameScreen(UUID uuid) {
        super((AbstractContainerMenu)new DummyContainer(), Minecraft.m_91087_().f_91074_.m_150109_(), (Component)Component.m_237115_((String)"gui.frame.resize"));
        this.uuid = uuid;
        this.visibility = ((Double)Main.CLIENT_CONFIG.resizeGuiOpacity.get()).floatValue();
        this.f_97726_ = 248;
        this.f_97727_ = 109;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int left = (this.f_96543_ - this.f_97726_) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.sendMoveImage(MessageResizeFrame.Direction.LEFT)).m_252987_(left + 10, this.f_96544_ / 2 - 10, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.sendMoveImage(MessageResizeFrame.Direction.RIGHT)).m_252987_(left + this.f_97726_ - 50 - 10, this.f_96544_ / 2 - 10, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.sendMoveImage(MessageResizeFrame.Direction.UP)).m_252987_(this.f_96543_ / 2 - 25, this.f_97736_ + 10, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), button -> this.sendMoveImage(MessageResizeFrame.Direction.DOWN)).m_252987_(this.f_96543_ / 2 - 25, this.f_97736_ + this.f_97727_ - 10 - 20, 50, 20).m_253136_());
        this.visibilityButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"tooltip.visibility_short"), button -> {
            this.visibility = (float)((double)this.visibility - 0.25);
            if (this.visibility < 0.0f) {
                this.visibility = 1.0f;
            }
            Main.CLIENT_CONFIG.resizeGuiOpacity.set((Object)this.visibility);
            Main.CLIENT_CONFIG.resizeGuiOpacity.save();
        }).m_252987_(left + this.f_97726_ - 20 - 10, this.f_97736_ + 10, 20, 20).m_253136_());
    }

    private void sendMoveImage(MessageResizeFrame.Direction direction) {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageResizeFrame(this.uuid, direction, !Screen.m_96638_()));
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        if (this.visibility >= 1.0f) {
            this.m_280273_(guiGraphics);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.visibility);
        guiGraphics.m_280218_(CAMERA_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
        MutableComponent title = Component.m_237115_((String)"gui.frame.resize");
        int titleWidth = this.f_96547_.m_92852_((FormattedText)title);
        FormattedCharSequence formattedCharSequence = title.m_7532_();
        int n = this.f_97726_ / 2 - titleWidth / 2;
        int n2 = this.f_97727_ / 2;
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, n, n2 - 9 - 1, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
        MutableComponent description = Component.m_237115_((String)"gui.frame.resize_description");
        int descriptionWidth = this.f_96547_.m_92852_((FormattedText)description);
        guiGraphics.m_280649_(this.f_96547_, description.m_7532_(), this.f_97726_ / 2 - descriptionWidth / 2, this.f_97727_ / 2 + 1, ChatFormatting.GRAY.m_126665_().intValue(), false);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.visibility);
        if (Screen.m_96638_()) {
            guiGraphics.m_280218_(CAMERA_TEXTURE, this.f_97726_ / 2 - 8, 12, 16, 109, 16, 16);
            guiGraphics.m_280218_(CAMERA_TEXTURE, this.f_97726_ / 2 - 8, this.f_97727_ - 10 - 20 + 2, 0, 109, 16, 16);
            guiGraphics.m_280218_(CAMERA_TEXTURE, 27, this.f_97727_ / 2 - 10 + 3, 0, 125, 16, 16);
            guiGraphics.m_280218_(CAMERA_TEXTURE, this.f_97726_ - 10 - 25 - 8, this.f_97727_ / 2 - 10 + 3, 16, 125, 16, 16);
        } else {
            guiGraphics.m_280218_(CAMERA_TEXTURE, this.f_97726_ / 2 - 8, 12, 0, 109, 16, 16);
            guiGraphics.m_280218_(CAMERA_TEXTURE, this.f_97726_ / 2 - 8, this.f_97727_ - 10 - 20 + 2, 16, 109, 16, 16);
            guiGraphics.m_280218_(CAMERA_TEXTURE, 27, this.f_97727_ / 2 - 10 + 3, 16, 125, 16, 16);
            guiGraphics.m_280218_(CAMERA_TEXTURE, this.f_97726_ - 10 - 25 - 8, this.f_97727_ / 2 - 10 + 3, 0, 125, 16, 16);
        }
        if (this.visibilityButton.m_198029_()) {
            guiGraphics.m_280245_(this.f_96547_, List.of(Component.m_237115_((String)"tooltip.visibility").m_7532_()), x - this.f_97735_, y - this.f_97736_);
        }
    }

    public void m_181908_() {
        super.m_181908_();
        if (System.currentTimeMillis() - this.lastCheck > 500L) {
            if (!this.isImagePresent()) {
                this.f_96541_.f_91074_.m_6915_();
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public boolean isImagePresent() {
        AABB aabb = this.f_96541_.f_91074_.m_20191_();
        aabb = aabb.m_82400_(32.0);
        return this.f_96541_.f_91073_.m_45976_(ImageEntity.class, aabb).stream().anyMatch(image -> image.m_20148_().equals(this.uuid) && image.m_20270_((Entity)this.f_96541_.f_91074_) <= 32.0f);
    }
}

