/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralBuilder;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPeripheralProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GenericPeripheralProvider.class);
    private static final ArrayList<Capability<?>> capabilities = new ArrayList();

    public static synchronized void addCapability(Capability<?> capability) {
        Objects.requireNonNull(capability, "Capability cannot be null");
        if (!capabilities.contains(capability)) {
            capabilities.add(capability);
        }
    }

    @Nullable
    public static IPeripheral getPeripheral(Level level, BlockPos pos, Direction side, NonNullConsumer<Object> invalidate) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return null;
        }
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            LOG.warn("Fetching peripherals on a non-server level {}.", (Object)level, (Object)new IllegalStateException("Fetching peripherals on a non-server level."));
            return null;
        }
        GenericPeripheralBuilder builder = new GenericPeripheralBuilder(server);
        builder.addMethods(blockEntity);
        for (Capability<?> capability : capabilities) {
            LazyOptional<?> wrapper = CapabilityUtil.getCapability((ICapabilityProvider)blockEntity, capability, side);
            wrapper.ifPresent(contents -> {
                if (builder.addMethods(contents)) {
                    CapabilityUtil.addListener(wrapper, invalidate);
                }
            });
        }
        return builder.toPeripheral(blockEntity, side);
    }
}

